/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.Serializable;
import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.alignment.GapIterator;
import pal.misc.SimpleIdGroup;

public class GapBalancedAlignment
extends AbstractAlignment
implements Serializable {
    static final int DEFAULT_CODON_LENGTH = 3;
    private char[][] data_;

    public GapBalancedAlignment(Alignment base, int startingCodonPosition, boolean alignGap) {
        this.calculateData(base, startingCodonPosition, alignGap, 3);
    }

    public GapBalancedAlignment(Alignment base, int startingCodonPosition, int codonLength) {
        this.calculateData(base, startingCodonPosition, true, codonLength);
    }

    public GapBalancedAlignment(Alignment base, int startingCodonPosition, boolean alignGap, int codonLength) {
        this.calculateData(base, startingCodonPosition, alignGap, codonLength);
    }

    private void calculateData(Alignment base, int startingCodonPosition, boolean alignGap, int codonLength) {
        GapIterator gi = new GapIterator(base, startingCodonPosition, alignGap, codonLength);
        gi.processAllSites();
        this.data_ = gi.getData();
        this.numSeqs = gi.getNumberOfSequences();
        this.numSites = gi.getNumberOfAcceptedSites();
        this.idGroup = new SimpleIdGroup(base);
        this.dataType = base.getDataType();
    }

    public char getData(int seq, int site) {
        return this.data_[seq][site];
    }

    static {
        DEFAULT_CODON_LENGTH = 3;
    }
}

