/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.Alignment;
import pal.datatype.DataType;

class GapIterator {
    Alignment base_;
    DataType dataType_;
    int startingCodonPosition_;
    int numberOfSites_ = -1;
    int numberOfSequences_ = -1;
    boolean[] siteAcceptance_ = null;
    int numberOfAcceptedSites_ = -1;
    int[] currentSequenceCodonPosition_ = null;
    int[] gapCount_ = null;
    int currentSite_ = -1;
    int codonLength_ = -1;
    int currentCodonPosition_ = -1;
    int[] currentCodonSites_;
    int numberOfCurrentCodonSites_ = -1;
    transient boolean acceptSite_ = false;
    transient int predominateCodonPosition_ = -1;
    boolean alignGaps_;

    public GapIterator(Alignment base, int startingCodonPosition, boolean alignGaps, int codonLength) {
        this.base_ = base;
        this.dataType_ = base.getDataType();
        this.alignGaps_ = alignGaps;
        this.startingCodonPosition_ = startingCodonPosition;
        this.codonLength_ = codonLength;
        this.setup();
        this.reset();
    }

    private void setup() {
        this.numberOfSites_ = this.base_.getSiteCount();
        this.numberOfSequences_ = this.base_.getSequenceCount();
        this.siteAcceptance_ = new boolean[this.numberOfSites_];
        this.currentSequenceCodonPosition_ = new int[this.numberOfSequences_];
        this.gapCount_ = new int[this.numberOfSequences_];
        this.currentCodonSites_ = new int[this.codonLength_];
    }

    public void reset() {
        int i = 0;
        while (i < this.siteAcceptance_.length) {
            this.siteAcceptance_[i] = false;
            ++i;
        }
        this.numberOfAcceptedSites_ = 0;
        int i2 = 0;
        while (i2 < this.currentSequenceCodonPosition_.length) {
            this.currentSequenceCodonPosition_[i2] = this.startingCodonPosition_;
            this.gapCount_[i2] = this.startingCodonPosition_;
            ++i2;
        }
        this.currentSite_ = 0;
        this.currentCodonPosition_ = this.startingCodonPosition_;
    }

    public final void processAllSites() {
        while (this.hasMoreSites()) {
            this.processAnotherSite();
        }
    }

    public boolean hasMoreSites() {
        return this.currentSite_ < this.numberOfSites_;
    }

    public int getCurrentSite() {
        return this.currentSite_;
    }

    private synchronized void processSite(int siteNumber) {
        this.acceptSite_ = true;
        this.predominateCodonPosition_ = -1;
        int currentSequence = 0;
        while (currentSequence < this.numberOfSequences_) {
            char c = this.base_.getData(currentSequence, this.currentSite_);
            if (!this.dataType_.isUnknownChar(c)) {
                this.predominateCodonPosition_ = this.currentSequenceCodonPosition_[currentSequence];
                break;
            }
            ++currentSequence;
        }
        if (this.predominateCodonPosition_ < 0) {
            this.acceptSite_ = false;
            return;
        }
        int currentSequence2 = 0;
        while (currentSequence2 < this.numberOfSequences_) {
            char c = this.base_.getData(currentSequence2, this.currentSite_);
            if (!this.dataType_.isUnknownChar(c)) {
                if (this.currentSequenceCodonPosition_[currentSequence2] != this.predominateCodonPosition_) {
                    this.acceptSite_ = false;
                }
                this.currentSequenceCodonPosition_[currentSequence2] = (this.currentSequenceCodonPosition_[currentSequence2] + 1) % this.codonLength_;
                this.gapCount_[currentSequence2] = this.currentSequenceCodonPosition_[currentSequence2];
            } else {
                if (this.alignGaps_ && this.currentSequenceCodonPosition_[currentSequence2] != 0 || this.gapCount_[currentSequence2] < this.codonLength_ && this.gapCount_[currentSequence2] != this.predominateCodonPosition_) {
                    this.acceptSite_ = false;
                }
                int n = currentSequence2;
                this.gapCount_[n] = this.gapCount_[n] + 1;
            }
            ++currentSequence2;
        }
    }

    private synchronized void acceptCurrentCodon() {
        int i = 0;
        while (i < 3) {
            this.siteAcceptance_[this.currentCodonSites_[i]] = true;
            ++i;
        }
        this.numberOfAcceptedSites_ += 3;
        this.removeCurrentCodon();
    }

    private synchronized void removeCurrentCodon() {
        this.currentCodonPosition_ = 0;
    }

    public synchronized void processAnotherSite() {
        this.processSite(this.currentSite_);
        if (this.acceptSite_) {
            if (this.predominateCodonPosition_ != this.currentCodonPosition_) {
                this.acceptSite_ = false;
                this.removeCurrentCodon();
            } else if (this.predominateCodonPosition_ >= 0) {
                this.currentCodonSites_[this.currentCodonPosition_] = this.currentSite_;
                ++this.currentCodonPosition_;
                if (this.currentCodonPosition_ == 3) {
                    this.acceptCurrentCodon();
                }
            }
        } else if (this.predominateCodonPosition_ >= 0) {
            this.removeCurrentCodon();
        }
        ++this.currentSite_;
    }

    public int getNumberOfSequences() {
        return this.numberOfSequences_;
    }

    public int getNumberOfAcceptedSites() {
        return this.numberOfAcceptedSites_;
    }

    public synchronized char[][] getData() {
        char[][] data = new char[this.numberOfSequences_][this.numberOfAcceptedSites_];
        int currentAcceptedSiteIndex = 0;
        int j = 0;
        while (j < this.numberOfSites_) {
            if (this.siteAcceptance_[j]) {
                int i = 0;
                while (i < this.numberOfSequences_) {
                    data[i][currentAcceptedSiteIndex] = this.base_.getData(i, j);
                    ++i;
                }
                ++currentAcceptedSiteIndex;
            }
            ++j;
        }
        return data;
    }
}

