/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.datatype.DataType;
import pal.misc.IdGroup;

public class SitePattern
extends AbstractAlignment {
    public int numPatterns;
    public int[] alias;
    public int[] weight;
    public byte[][] pattern;
    private int[] patSort;

    public char getData(int seq, int site) {
        return this.dataType.getChar(this.pattern[seq][this.alias[site]]);
    }

    public SitePattern(Alignment a) {
        if (a.getDataType() == null) {
            a.setDataType(AlignmentUtils.getSuitableInstance(a));
        }
        this.dataType = a.getDataType();
        this.numSites = a.getSiteCount();
        this.numSeqs = a.getSequenceCount();
        this.idGroup = a;
        this.frequency = a.getFrequency();
        this.makeSitePattern(a);
    }

    public SitePattern(DataType dataType, int numSites, int numSeqs, IdGroup idGroup, int numPatterns, int[] alias, int[] weight, byte[][] pattern) {
        this.dataType = dataType;
        this.numSites = numSites;
        this.numSeqs = numSeqs;
        this.idGroup = idGroup;
        this.numPatterns = numPatterns;
        this.alias = alias;
        this.weight = weight;
        this.pattern = pattern;
        AlignmentUtils.estimateFrequencies(this);
    }

    private void makeSitePattern(Alignment alignment) {
        this.alias = new int[this.numSites];
        if (this.numSeqs > 0 && this.numSites > 0) {
            this.patSort = new int[this.numSites];
            this.getNumpattern(alignment);
            this.pattern = new byte[this.numSeqs][this.numPatterns];
            this.weight = new int[this.numPatterns];
            this.copypattern(alignment);
            this.patSort = null;
        } else {
            this.numPatterns = 0;
            this.pattern = null;
            this.weight = null;
        }
    }

    private int stateData(Alignment al, int seq, int site) {
        return this.dataType.getState(al.getData(seq, site));
    }

    private void getNumpattern(Alignment alignment) {
        byte tpmradix = (byte)this.dataType.getNumStates();
        int[] awork = new int[this.numSites];
        int[] count = new int[tpmradix + 1];
        int j = 0;
        while (j < this.numSites) {
            this.patSort[j] = j;
            ++j;
        }
        int i = this.numSeqs - 1;
        while (i >= 0) {
            int k = 0;
            while (k < tpmradix + 1) {
                count[k] = 0;
                ++k;
            }
            int j2 = 0;
            while (j2 < this.numSites) {
                int n = this.stateData(alignment, i, this.patSort[j2]);
                count[n] = count[n] + 1;
                ++j2;
            }
            int k2 = 1;
            while (k2 < tpmradix + 1) {
                int n = k2;
                count[n] = count[n] + count[k2 - 1];
                ++k2;
            }
            int j3 = this.numSites - 1;
            while (j3 >= 0) {
                int n = this.stateData(alignment, i, this.patSort[j3]);
                int n2 = count[n] - 1;
                count[n] = n2;
                awork[n2] = this.patSort[j3];
                --j3;
            }
            int j4 = 0;
            while (j4 < this.numSites) {
                this.patSort[j4] = awork[j4];
                ++j4;
            }
            --i;
        }
        awork = null;
        count = null;
        this.numPatterns = 1;
        int j5 = 1;
        while (j5 < this.numSites) {
            int s = this.patSort[j5 - 1];
            int t = this.patSort[j5];
            int i2 = 0;
            while (i2 < this.numSeqs) {
                if (this.stateData(alignment, i2, t) != this.stateData(alignment, i2, s)) {
                    ++this.numPatterns;
                    break;
                }
                ++i2;
            }
            ++j5;
        }
    }

    void copypattern(Alignment alignment) {
        int n = 0;
        int k = this.patSort[n];
        int i = 0;
        while (i < this.numSeqs) {
            this.pattern[i][n] = (byte)this.stateData(alignment, i, k);
            ++i;
        }
        this.weight[n] = 1;
        this.alias[k] = 0;
        int j = 1;
        while (j < this.numSites) {
            k = this.patSort[j];
            boolean isSame = true;
            int i2 = 0;
            while (i2 < this.numSeqs) {
                if (this.pattern[i2][n] != (byte)this.stateData(alignment, i2, k)) {
                    isSame = false;
                    break;
                }
                ++i2;
            }
            if (isSame) {
                int n2 = n;
                this.weight[n2] = this.weight[n2] + 1;
                this.alias[k] = n;
            } else {
                ++n;
                int i3 = 0;
                while (i3 < this.numSeqs) {
                    this.pattern[i3][n] = (byte)this.stateData(alignment, i3, k);
                    ++i3;
                }
                this.weight[n] = 1;
                this.alias[k] = n;
            }
            ++j;
        }
    }

    public static final SitePattern getSitePattern(Alignment a) {
        if (a instanceof SitePattern) {
            return (SitePattern)a;
        }
        return new SitePattern(a);
    }
}

