/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.PrintWriter;
import pal.alignment.AlignmentUtils;
import pal.alignment.AnnotationAlignment;
import pal.alignment.StrippedAlignment;
import pal.datatype.DataType;

public class StrippedAnnotatedAlignment
extends StrippedAlignment
implements AnnotationAlignment {
    private AnnotationAlignment rawAlignment = null;
    private int rawNumSites;
    protected double minimumProportion = 0.0;
    protected int minimumCount = 0;
    protected int firstSite = 0;
    protected int lastSite = 0;

    public StrippedAnnotatedAlignment(AnnotationAlignment a) {
        super(a);
        this.dataType = a.getDataType();
        this.rawAlignment = a;
        this.firstSite = 0;
        this.lastSite = this.rawAlignment.getSiteCount();
    }

    public float getChromosomePosition(int site) {
        return this.rawAlignment.getChromosomePosition(this.alias[site]);
    }

    public int getChromosome(int site) {
        return this.rawAlignment.getChromosome(this.alias[site]);
    }

    public float getWeightedLocusPosition(int site) {
        return this.rawAlignment.getWeightedLocusPosition(this.alias[site]);
    }

    public int getLocusPosition(int site) {
        return this.rawAlignment.getLocusPosition(this.alias[site]);
    }

    public char getPositionType(int site) {
        return this.rawAlignment.getPositionType(this.alias[site]);
    }

    public String getLocusName(int site) {
        return this.rawAlignment.getLocusName(this.alias[site]);
    }

    public DataType getDataType(int site) {
        return this.rawAlignment.getDataType(this.alias[site]);
    }

    public void removeSitesOutsideRange(int firstSite, int lastSite) {
        this.firstSite = firstSite;
        this.lastSite = lastSite;
        int i = 0;
        while (i < this.rawAlignment.getSiteCount()) {
            if (this.rawAlignment.getLocusPosition(i) < firstSite || this.rawAlignment.getLocusPosition(i) > lastSite) {
                this.dropSite(i);
            }
            ++i;
        }
    }

    public void removeConstantSitesIgnoreGapsMissing() {
        int[] charCount = new int[this.numSeqs];
        int i = 0;
        while (i < this.rawAlignment.getSiteCount()) {
            int j = 0;
            while (j < this.numSeqs) {
                charCount[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < this.numSeqs) {
                char c = this.rawAlignment.getData(j2, i);
                if (c != '-' && c != '?' && charCount[j2] == 0) {
                    charCount[j2] = 1;
                    int k = j2 + 1;
                    while (k < this.numSeqs) {
                        if (c == this.rawAlignment.getData(k, i)) {
                            int n = j2;
                            charCount[n] = charCount[n] + 1;
                            charCount[k] = -1;
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            int num = 0;
            int j3 = 0;
            while (j3 < this.numSeqs) {
                if (charCount[j3] > 1) {
                    ++num;
                }
                ++j3;
            }
            if (num < 2) {
                this.dropSite(i);
            }
            ++i;
        }
    }

    public void removeSitesBasedOnFreqIgnoreGapsMissing(double minimumProportion, int minimumCount) {
        this.minimumProportion = minimumProportion;
        this.minimumCount = minimumCount;
        int[] charCount = new int[this.numSeqs];
        int i = 0;
        while (i < this.rawAlignment.getSiteCount()) {
            int j = 0;
            while (j < this.numSeqs) {
                charCount[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < this.numSeqs) {
                char c = this.rawAlignment.getData(j2, i);
                if (charCount[j2] == 0 && c != '-' && c != '?') {
                    charCount[j2] = 1;
                    int k = j2 + 1;
                    while (k < this.numSeqs) {
                        if (c == this.rawAlignment.getData(k, i)) {
                            int n = j2;
                            charCount[n] = charCount[n] + 1;
                            charCount[k] = -1;
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            int num = 0;
            int totalGood = 0;
            int maxProportion = 0;
            int j3 = 0;
            while (j3 < this.numSeqs) {
                if (charCount[j3] > 0) {
                    ++num;
                    totalGood += charCount[j3];
                    if (charCount[j3] > maxProportion) {
                        maxProportion = charCount[j3];
                    }
                }
                ++j3;
            }
            double obsMinProp = 1.0 - (double)maxProportion / (double)totalGood;
            if (totalGood == 0 || totalGood < minimumCount || obsMinProp < minimumProportion) {
                this.dropSite(i);
            }
            ++i;
        }
    }

    public void report(PrintWriter out) {
        AlignmentUtils.report(this, out);
        out.println("Locus: " + this.getLocusName(0));
        out.println("Chromsome: " + this.getChromosome(0) + " Position: " + this.getChromosomePosition(0));
        out.println("Minimum Allele Frequency: " + this.minimumProportion);
        out.println("Polymorphism included if in >" + this.minimumCount + " good sequences");
        out.println("Range Start: " + this.firstSite + " End: " + this.lastSite);
    }
}

