/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.DataType;

public class IUPACNucleotides
implements DataType {
    private static final char[] CONVERSION_TABLE = new char[]{'A', 'C', 'G', 'U', 'K', 'M', 'R', 'S', 'W', 'Y', 'B', 'D', 'H', 'V', 'N', '?'};

    public int getNumStates() {
        return 15;
    }

    public boolean isUnknownState(int state) {
        return state >= this.getNumStates() || state < 0;
    }

    public int getNumSimpleStates() {
        return 4;
    }

    public final int getState(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'U': {
                return 3;
            }
            case 'K': {
                return 4;
            }
            case 'M': {
                return 5;
            }
            case 'R': {
                return 6;
            }
            case 'S': {
                return 7;
            }
            case 'W': {
                return 8;
            }
            case 'Y': {
                return 9;
            }
            case 'B': {
                return 10;
            }
            case 'D': {
                return 11;
            }
            case 'H': {
                return 12;
            }
            case 'V': {
                return 13;
            }
            case 'N': {
                return 14;
            }
        }
        return 15;
    }

    public char getChar(int state) {
        if (state < CONVERSION_TABLE.length && state >= 0) {
            return CONVERSION_TABLE[state];
        }
        return '?';
    }

    public String getDescription() {
        return "IUPACNucleotide";
    }

    public int getTypeID() {
        return 3;
    }

    public boolean isAmbiguousState(int state) {
        return state > 3 && state < this.getNumStates();
    }

    public int[] getSimpleStates(int state) {
        String stateString = "";
        switch (state) {
            case 0: {
                stateString = "A";
                break;
            }
            case 1: {
                stateString = "C";
                break;
            }
            case 2: {
                stateString = "G";
                break;
            }
            case 3: {
                stateString = "T";
                break;
            }
            case 4: {
                stateString = "GT";
                break;
            }
            case 5: {
                stateString = "AC";
                break;
            }
            case 6: {
                stateString = "AG";
                break;
            }
            case 7: {
                stateString = "CG";
                break;
            }
            case 8: {
                stateString = "AT";
                break;
            }
            case 9: {
                stateString = "CT";
                break;
            }
            case 10: {
                stateString = "CGT";
                break;
            }
            case 11: {
                stateString = "AGT";
                break;
            }
            case 12: {
                stateString = "ACT";
                break;
            }
            case 13: {
                stateString = "ACG";
                break;
            }
            case 14: {
                stateString = "ACGT";
                break;
            }
            default: {
                stateString = "ACGT";
            }
        }
        int[] states = new int[stateString.length()];
        int i = 0;
        while (i < stateString.length()) {
            states[i] = this.getState(stateString.charAt(i));
            ++i;
        }
        return states;
    }

    public boolean isUnknownChar(char c) {
        return this.isUnknownState(this.getChar(c));
    }
}

