/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.eval.LikelihoodValue;
import pal.math.MultivariateFunction;

class CombinedLikelihood
implements MultivariateFunction {
    private double[] f1Params_;
    private double[] f2Params_;
    private LikelihoodValue lv;
    private MultivariateFunction f1_;
    private MultivariateFunction f2_;

    public CombinedLikelihood(MultivariateFunction f1, MultivariateFunction f2, LikelihoodValue lv) {
        this.f1_ = f1;
        this.f2_ = f2;
        this.f1Params_ = new double[f1.getNumArguments()];
        this.f2Params_ = new double[f2.getNumArguments()];
    }

    public double evaluate(double[] params) {
        int i = 0;
        while (i < this.f1Params_.length) {
            this.f1Params_[i] = params[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.f2Params_.length) {
            this.f2Params_[i2] = params[i2 - this.f1Params_.length];
            ++i2;
        }
        return -this.lv.compute();
    }

    public int getNumArguments() {
        return this.f1Params_.length + this.f2Params_.length;
    }

    public double getLowerBound(int n) {
        if (n < this.f1Params_.length) {
            this.f1_.getLowerBound(n);
        }
        return this.f2_.getLowerBound(n - this.f1Params_.length);
    }

    public double getUpperBound(int n) {
        if (n < this.f1Params_.length) {
            this.f1_.getUpperBound(n);
        }
        return this.f2_.getUpperBound(n - this.f1Params_.length);
    }
}

