/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.io.Serializable;
import java.util.Hashtable;
import pal.misc.Identifier;

public final class NameColouriser
implements Serializable {
    Hashtable colourMappings_ = new Hashtable();

    public NameColouriser() {
    }

    public NameColouriser(String name, Color colour) {
        this.addMapping(name, colour);
    }

    public NameColouriser(Identifier name, Color colour) {
        this.addMapping(name, colour);
    }

    public void addMapping(String name, Color colour) {
        this.colourMappings_.put(name, colour);
    }

    public void addMapping(Identifier id, Color colour) {
        if (id != null && id.getName() != null) {
            this.colourMappings_.put(id.getName(), colour);
        }
    }

    public void addMappings(String[] names, Color[] colours) {
        int i = 0;
        while (i < names.length) {
            this.colourMappings_.put(names[i], colours[i]);
            ++i;
        }
    }

    public Color getColour(String name, Color defaultColour) {
        if (name == null || !this.colourMappings_.containsKey(name)) {
            return defaultColour;
        }
        return (Color)this.colourMappings_.get(name);
    }

    public Color getColour(Identifier id, Color defaultColour) {
        if (id == null) {
            return defaultColour;
        }
        return this.getColour(id.getName(), defaultColour);
    }
}

