/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import pal.gui.LayoutTracker;
import pal.gui.PositionedNode;
import pal.gui.TreePainter;
import pal.io.FormattedOutput;
import pal.tree.Tree;

public class TreePainterNormal
extends TreePainter {
    public static final int RIGHTBORDER = 75;
    public static final int LEFTBORDER = 10;
    public static final int TOPBORDER = 20;
    public static final int BOTTOMBORDER = 30;
    public static final int FONT_SIZE = 11;
    public static final int YSPACER = 20;
    public static final int XSPACER = 4;
    private double xScale = 1.0;
    private double yScale = 1.0;

    public TreePainterNormal(Tree toDisplay, String title, boolean showTitle) {
        super(toDisplay, title, showTitle);
    }

    public Dimension getPreferredSize() {
        return new Dimension(185, (int)Math.round(this.width * 11.0) + 20 + 30);
    }

    protected void paint(PositionedNode node, Graphics g, int displayWidth, int displayHeight, LayoutTracker lt) {
        Point p = this.getPoint(node, displayWidth, displayHeight);
        g.setColor(TreePainter.FOREGROUND);
        if (node.hasChildren()) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.paintLeafBranch(p, this.getPoint((PositionedNode)node.getChild(i), displayWidth, displayHeight), node, g, lt);
                ++i;
            }
            int i2 = 0;
            while (i2 < node.getChildCount()) {
                this.paint((PositionedNode)node.getChild(i2), g, displayWidth, displayHeight, lt);
                ++i2;
            }
            int bootStrapValue = this.getBootstrapValue(node);
            if (bootStrapValue >= 50) {
                g.setColor(TreePainter.BOOTSTRAP_SUPPORT_COLOUR);
                g.drawString(bootStrapValue + "", p.x + 4, p.y + 5);
            }
        } else {
            if (this.maxLeafTime > 0.0 && this.isUsingColor()) {
                g.setColor(Color.getHSBColor((float)(this.maxLeafTime - node.getNodeHeight()) / (float)this.maxLeafTime, 1.0f, 1.0f));
            } else {
                g.setColor(TreePainter.NORMAL_LABEL_COLOR);
            }
            if (this.isUsingColor()) {
                int halfWidth = this.getPenWidth() / 2;
                g.fillRect(p.x - halfWidth, p.y - halfWidth, this.getPenWidth(), this.getPenWidth());
            }
            if (this.isUsingSymbols() && this.getTimeOrderCharacterData() != null) {
                TreePainter.drawSymbol(g, p.x + 4, p.y - 5, 11, this.getTimeOrderCharacterData().getTimeOrdinal(this.getTimeOrderCharacterData().whichIdNumber(node.getIdentifier().getName())));
            } else {
                String name = this.getNodeName(node);
                int width = g.getFontMetrics().stringWidth(name);
                if (this.isUsingColor()) {
                    g.drawString(name, p.x + 4, p.y + 5);
                    if (node.isHighlighted()) {
                        g.setColor(Color.red);
                        g.drawOval(p.x - 4 + 4, p.y - 5 - 5, width + 10, 19);
                    }
                } else {
                    Color defaultColour = node.isHighlighted() ? TreePainter.HILITED_LABEL_COLOR : TreePainter.NORMAL_LABEL_COLOR;
                    g.setColor(this.getNodeLabelColour(node, defaultColour));
                    g.drawString(name, p.x + 4, p.y + 5);
                }
                if (lt != null) {
                    lt.addMapping(name, new Rectangle(p.x + 4, p.y - 5, width, 11));
                }
            }
        }
    }

    public Point getPoint(PositionedNode node, int displayWidth, int displayHeight) {
        return new Point(displayWidth - (int)Math.round(node.getNodeHeight() * this.xScale) - 75, (int)Math.round(node.x * this.yScale) + 20);
    }

    private void paintLeafBranch(Point p, Point lp, PositionedNode node, Graphics g, LayoutTracker lt) {
        int x;
        int width;
        String label;
        int halfWidth = this.getPenWidth() / 2;
        g.fillRect(p.x - halfWidth, Math.min(p.y, lp.y) - halfWidth, this.getPenWidth(), Math.abs(lp.y - p.y) + this.getPenWidth());
        g.fillRect(Math.min(p.x, lp.x) - halfWidth, lp.y - halfWidth, Math.abs(lp.x - p.x) + this.getPenWidth(), this.getPenWidth());
        if (this.isShowingNodeHeights()) {
            label = FormattedOutput.getInstance().getDecimalString(node.getNodeHeight(), 4);
            width = g.getFontMetrics().stringWidth(label);
            x = Math.min(p.x, lp.x) - width / 2;
            g.drawString(label, x, p.y - halfWidth - 1);
        }
        if (this.isShowingInternalLabels()) {
            label = this.getNodeName(node);
            width = g.getFontMetrics().stringWidth(label);
            x = Math.min(p.x, lp.x) - width / 2;
            g.drawString(label, x, p.y - halfWidth - 1);
        }
        Object att = null;
        if (this.attName != null && (att = this.attName.equals("node height") ? new Double(node.getNodeHeight()) : (this.attName.equals("branch length") ? new Double(node.getBranchLength()) : node.getAttribute(this.attName))) != null) {
            String label2 = null;
            label2 = att instanceof Double ? FormattedOutput.getInstance().getDecimalString((Double)att, 3) : att.toString();
            int width2 = g.getFontMetrics().stringWidth(label2);
            int height = g.getFontMetrics().getAscent();
            int x2 = Math.min(p.x, lp.x) + halfWidth + 1;
            g.drawString(label2, x2, p.y + height / 2);
        }
    }

    public void paint(Graphics g, int displayWidth, int displayHeight) {
        this.paint(g, displayWidth, displayHeight, null);
    }

    public void paint(Graphics g, int displayWidth, int displayHeight, LayoutTracker lt) {
        g.setFont(new Font("Times", 0, 11));
        this.xScale = (double)(displayWidth - 10 - 75) / this.height;
        this.yScale = (double)(displayHeight - 20 - 30) / this.width;
        g.setColor(TreePainter.BACKGROUND);
        g.fillRect(0, 0, displayWidth, displayHeight);
        this.paint(this.treeNode, g, displayWidth, displayHeight, lt);
        this.doTitle(g, 10, 12);
        this.doScale(g, this.xScale, 10, displayHeight - 30 + 12);
    }

    static {
        RIGHTBORDER = 75;
        LEFTBORDER = 10;
        TOPBORDER = 20;
        BOTTOMBORDER = 30;
        FONT_SIZE = 11;
        YSPACER = 20;
        XSPACER = 4;
    }
}

