/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.MultivariateFunction;

public abstract class MultivariateMinimum {
    public int numFun;
    public int maxFun = 0;
    public int numFuncStops = 4;
    private int countFuncStops;
    private double fxold;
    private double[] xold;

    public double findMinimum(MultivariateFunction f, double[] xvec) {
        this.optimize(f, xvec, MachineAccuracy.EPSILON, MachineAccuracy.EPSILON);
        return f.evaluate(xvec);
    }

    public double findMinimum(MultivariateFunction f, double[] xvec, int fxFracDigits, int xFracDigits) {
        double tolfx = Math.pow(10.0, -1 - fxFracDigits);
        double tolx = Math.pow(10.0, -1 - xFracDigits);
        this.optimize(f, xvec, tolfx, tolx);
        double m = Math.pow(10.0, xFracDigits);
        int i = 0;
        while (i < xvec.length) {
            xvec[i] = (double)Math.round(xvec[i] * m) / m;
            ++i;
        }
        return (double)Math.round(f.evaluate(xvec) * m) / m;
    }

    public abstract void optimize(MultivariateFunction var1, double[] var2, double var3, double var5);

    public boolean stopCondition(double fx, double[] x, double tolfx, double tolx, boolean firstCall) {
        boolean stop = false;
        if (firstCall) {
            this.countFuncStops = 0;
            this.fxold = fx;
            this.xold = new double[x.length];
            this.copy(this.xold, x);
        } else if (this.xStop(x, this.xold, tolx)) {
            stop = true;
        } else {
            this.countFuncStops = this.fxStop(fx, this.fxold, tolfx) ? ++this.countFuncStops : 0;
            if (this.countFuncStops >= this.numFuncStops) {
                stop = true;
            }
        }
        if (!stop) {
            this.fxold = fx;
            this.copy(this.xold, x);
        }
        return stop;
    }

    public void copy(double[] target, double[] source) {
        int i = 0;
        while (i < source.length) {
            target[i] = source[i];
            ++i;
        }
    }

    private boolean xStop(double[] x, double[] xold, double tolx) {
        boolean stop = true;
        int i = 0;
        while (i < x.length && stop) {
            if (Math.abs(x[i] - xold[i]) > tolx) {
                stop = false;
            }
            ++i;
        }
        return stop;
    }

    private boolean fxStop(double fx, double fxold, double tolfx) {
        return !(Math.abs(fx - fxold) > tolfx);
    }
}

