/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalLineFunction;
import pal.math.UnivariateMinimum;

public class StochasticOSearch
extends MultivariateMinimum {
    private static MersenneTwisterFast random = new MersenneTwisterFast();
    private UnivariateMinimum um = new UnivariateMinimum();
    private int numArgs;

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx) {
        this.numArgs = f.getNumArguments();
        this.numFun = 1;
        double fx = f.evaluate(xvec);
        this.stopCondition(fx, xvec, tolfx, tolx, true);
        OrthogonalLineFunction olf = new OrthogonalLineFunction(f);
        olf.setAllArguments(xvec);
        int[] ordering = new int[this.numArgs];
        int i = 0;
        while (i < ordering.length) {
            ordering[i] = i;
            ++i;
        }
        do {
            random.shuffle(ordering);
            int i2 = 0;
            while (i2 < this.numArgs) {
                int argument = ordering[i2];
                olf.selectArgument(argument);
                xvec[argument] = this.um.optimize(olf, tolx);
                if (this.um.fminx < fx) {
                    olf.setArgument(xvec[argument]);
                    fx = this.um.fminx;
                }
                this.numFun += this.um.numFun;
                ++i2;
            }
        } while (!this.stopCondition(fx, xvec, tolfx, tolx, false) && (this.maxFun <= 0 || this.numFun <= this.maxFun) && this.numArgs != 1);
    }
}

