/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.io.OutputTarget;
import pal.mep.MutationRateModel;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;

public class SteppedMutationRate
extends MutationRateModel
implements Report,
Summarizable,
Parameterized,
Serializable {
    public double[] mus;
    public double[] muSEs;
    public double[] muChanges;
    public boolean fixedMus = false;
    String[] summaryTypes = null;

    public SteppedMutationRate(double[] muChanges, int units) {
        this.setUnits(units);
        this.muChanges = muChanges;
        this.mus = new double[muChanges.length + 1];
        this.muSEs = new double[muChanges.length + 1];
        int i = 0;
        while (i < this.mus.length) {
            this.mus[i] = this.getDefaultValue(0);
            ++i;
        }
    }

    public SteppedMutationRate(double[] rates, double[] muChanges, int units) {
        this(rates, muChanges, units, false);
    }

    public SteppedMutationRate(double[] rates, double[] muChanges, int units, boolean fixed) {
        this.fixedMus = fixed;
        this.mus = rates;
        this.muSEs = new double[rates.length];
        this.muChanges = muChanges;
        this.setUnits(units);
    }

    public Object clone() {
        return new SteppedMutationRate(this.getMus(), this.getMuChanges(), this.getUnits(), this.fixedMus);
    }

    public String[] getSummaryTypes() {
        if (this.summaryTypes == null) {
            this.summaryTypes = new String[this.mus.length];
            int i = 0;
            while (i < this.summaryTypes.length) {
                this.summaryTypes[i] = "mu " + i;
                ++i;
            }
        }
        return this.summaryTypes;
    }

    public double getSummaryValue(int summaryType) {
        if (summaryType < this.mus.length) {
            return this.mus[summaryType];
        }
        throw new RuntimeException("Assertion error: unknown summary type :" + summaryType);
    }

    public double getMu() {
        return this.mus[0];
    }

    public void setMu(double m) {
        this.mus[0] = m;
    }

    public final double getMutationRate(double t) {
        int muIndex = 0;
        while (muIndex < this.muChanges.length && t > this.muChanges[muIndex]) {
            ++muIndex;
        }
        return this.mus[muIndex];
    }

    public final double getExpectedSubstitutions(double time) {
        double currentTime = 0.0;
        double height = 0.0;
        int muIndex = 0;
        double timeInterval = 0.0;
        while (time > currentTime) {
            if (muIndex >= this.muChanges.length) {
                timeInterval = time - currentTime;
                currentTime = time;
            } else {
                timeInterval = this.muChanges[muIndex] - currentTime;
                if (currentTime + timeInterval > time) {
                    timeInterval = time - currentTime;
                    currentTime = time;
                } else {
                    currentTime = this.muChanges[muIndex];
                }
            }
            height += this.mus[muIndex] * timeInterval;
            ++muIndex;
        }
        return height;
    }

    public final double getTime(double expectedSubs) {
        int changePoint = 0;
        while (changePoint < this.muChanges.length && expectedSubs < this.getExpectedSubstitutions(this.muChanges[changePoint])) {
            ++changePoint;
        }
        if (changePoint == 0) {
            return expectedSubs / this.mus[changePoint];
        }
        double time = this.muChanges[changePoint - 1];
        double expectedSoFar = this.getExpectedSubstitutions(time);
        return time += (expectedSubs - expectedSoFar) / this.mus[changePoint];
    }

    public final void scale(double scale) {
        int i = 0;
        while (i < this.mus.length) {
            int n = i++;
            this.mus[n] = this.mus[n] * scale;
        }
    }

    public static double[] getTimeIntervals(double[] muChanges, double smallTime, double bigTime) {
        double[] intervals = new double[muChanges.length + 1];
        double currentTime = smallTime;
        double height = 0.0;
        int muIndex = 0;
        while (muIndex < muChanges.length && muChanges[muIndex] < smallTime) {
            ++muIndex;
        }
        double timeInterval = 0.0;
        while (bigTime > currentTime) {
            if (muIndex >= muChanges.length) {
                intervals[muIndex] = bigTime - currentTime;
                currentTime = bigTime;
            } else {
                intervals[muIndex] = muChanges[muIndex] - currentTime;
                if (currentTime + intervals[muIndex] > bigTime) {
                    intervals[muIndex] = bigTime - currentTime;
                    currentTime = bigTime;
                } else {
                    currentTime = muChanges[muIndex];
                }
            }
            ++muIndex;
        }
        return intervals;
    }

    public double[] getDeltas(double[] times) {
        double height = 0.0;
        double[] deltas = new double[times.length - 1];
        int i = 0;
        while (i < deltas.length) {
            deltas[i] = this.getExpectedSubstitutions(times[i + 1]) - height;
            height += deltas[i];
            ++i;
        }
        return deltas;
    }

    public int getNumParameters() {
        if (this.fixedMus) {
            return 0;
        }
        return this.mus.length;
    }

    public double getParameter(int k) {
        return this.mus[k];
    }

    public double getUpperLimit(int k) {
        return 1.0E12;
    }

    public double getLowerLimit(int k) {
        return 0.0;
    }

    public double getDefaultValue(int k) {
        if (this.getUnits() == 1) {
            return 1.0E-6;
        }
        return 1.0E-6;
    }

    public void setParameter(double value, int k) {
        this.mus[k] = value;
    }

    public void setParameterSE(double value, int k) {
        this.muSEs[k] = value;
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Mutation rate model: stepped mutation rate ");
        out.print("Unit of time: ");
        if (this.getUnits() == 1) {
            out.print("generations");
        } else {
            out.print("expected substitutions");
        }
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        out.println(" mu\tinterval");
        int i = 0;
        while (i < this.mus.length) {
            this.fo.displayDecimal(out, this.mus[i], 6);
            if (i == 0) {
                out.print("\t0.0 to ");
                this.fo.displayDecimal(out, this.muChanges[i], 6);
                out.println();
            } else {
                out.print("\t");
                this.fo.displayDecimal(out, this.muChanges[i - 1], 6);
                out.print(" to ");
                if (i < this.muChanges.length) {
                    this.fo.displayDecimal(out, this.muChanges[i], 6);
                    out.println();
                } else {
                    out.println("infinity");
                }
            }
            ++i;
        }
    }

    public double[] getMus() {
        double[] newMus = new double[this.mus.length];
        int i = 0;
        while (i < newMus.length) {
            newMus[i] = this.mus[i];
            ++i;
        }
        return newMus;
    }

    private double[] getMuChanges() {
        double[] newMCs = new double[this.muChanges.length];
        int i = 0;
        while (i < newMCs.length) {
            newMCs[i] = this.muChanges[i];
            ++i;
        }
        return newMCs;
    }

    public String toSingleLine() {
        String line = "";
        int i = 0;
        while (i < this.mus.length) {
            line = line + "mu[" + i + "]\t" + this.mus[i];
            if (i < this.mus.length - 1) {
                line = line + "\t";
            }
            ++i;
        }
        return line;
    }
}

