/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.Serializable;
import java.util.Hashtable;
import pal.misc.Identifier;

public class LabelMapping
implements Serializable {
    Hashtable mappings_ = new Hashtable();

    public void addMapping(String id, String label) {
        this.mappings_.put(id, label);
    }

    public void addMapping(Identifier id, String label) {
        if (id != null && id.getName() != null) {
            this.mappings_.put(id.getName(), label);
        }
    }

    public void addMappings(String[] ids, String[] labels) {
        int i = 0;
        while (i < ids.length) {
            this.mappings_.put(ids[i], labels[i]);
            ++i;
        }
    }

    public String getLabel(String id, String defaultLabel) {
        if (id == null || !this.mappings_.containsKey(id)) {
            return defaultLabel;
        }
        return this.mappings_.get(id).toString();
    }

    public String getLabel(Identifier id, String defaultLabel) {
        if (id == null) {
            return defaultLabel;
        }
        return this.getLabel(id.getName(), defaultLabel);
    }

    public String getLabel(Identifier id) {
        return this.getLabel(id.getName(), id.getName());
    }

    public Identifier getLabelIdentifier(Identifier id) {
        if (id == null) {
            return null;
        }
        return new Identifier(this.getLabel(id.getName(), id.getName()));
    }
}

