/*
 * Decompiled with CFR 0.152.
 */
package pal.popgen;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;
import pal.alignment.Alignment;
import pal.alignment.AnnotationAlignment;
import pal.datatype.DataType;
import pal.misc.TableReport;
import pal.statistics.ContigencyTable;
import pal.statistics.FisherExact;

public class LinkageDisequilibrium
extends Thread
implements Serializable,
TableReport {
    protected Alignment theAlignment;
    protected AnnotationAlignment theAnnotationAlignment = null;
    boolean annotated = false;
    Vector[] stateVector;
    boolean rapidPermute = true;
    int numberOfPermutations = 1000;
    double[][] diseq;
    double[][] pDiseq;
    private double currentProgress;

    public LinkageDisequilibrium(Alignment alignment) {
        this.theAlignment = alignment;
        if (this.theAlignment instanceof AnnotationAlignment) {
            this.annotated = true;
            this.theAnnotationAlignment = (AnnotationAlignment)this.theAlignment;
        }
    }

    public LinkageDisequilibrium(Alignment alignment, boolean rapidPermute, int numberOfPermutations) {
        this.theAlignment = alignment;
        this.rapidPermute = rapidPermute;
        this.numberOfPermutations = numberOfPermutations;
        if (this.theAlignment instanceof AnnotationAlignment) {
            this.annotated = true;
            this.theAnnotationAlignment = (AnnotationAlignment)this.theAlignment;
        }
    }

    public void run() {
        Date theDate = new Date();
        System.out.println("Start LD run");
        this.calculateMultiProbDiseq();
        Date stopDate = new Date();
        System.out.println("Stop LD run Time=" + (theDate.getTime() - stopDate.getTime()));
    }

    byte[][] determineNumberOfStates() {
        System.out.println("States starting to be loaded into S");
        this.stateVector = new Vector[this.theAlignment.getSiteCount()];
        byte[][] S = new byte[this.theAlignment.getSequenceCount()][this.theAlignment.getSiteCount()];
        int i = 0;
        while (i < this.theAlignment.getSiteCount()) {
            this.stateVector[i] = new Vector();
            int j = 0;
            while (j < this.theAlignment.getSequenceCount()) {
                char c = this.theAlignment.getData(j, i);
                if (c == '-' || c == '?') {
                    S[j][i] = -99;
                } else if (!this.stateVector[i].contains(new Character(c))) {
                    this.stateVector[i].add(new Character(c));
                    S[j][i] = (byte)this.stateVector[i].indexOf(new Character(c));
                } else {
                    S[j][i] = (byte)this.stateVector[i].indexOf(new Character(c));
                }
                ++j;
            }
            ++i;
        }
        System.out.println("States loaded into S");
        return S;
    }

    private void calculateMultiProbDiseq() {
        byte[][] S = this.determineNumberOfStates();
        ContigencyTable contigencyTable = new ContigencyTable(this.theAlignment.getSequenceCount() + 10);
        FisherExact fisherExact = new FisherExact(this.theAlignment.getSequenceCount() + 10);
        this.diseq = new double[this.theAlignment.getSiteCount()][this.theAlignment.getSiteCount()];
        this.pDiseq = new double[this.theAlignment.getSiteCount()][this.theAlignment.getSiteCount()];
        int r = 0;
        while (r < this.theAlignment.getSiteCount()) {
            this.currentProgress = 100 * r * r / (this.theAlignment.getSiteCount() * this.theAlignment.getSiteCount());
            int rows = this.stateVector[r].size();
            this.pDiseq[r][r] = 0.0;
            this.diseq[r][r] = 1.0;
            int c = 0;
            while (c < r) {
                int cols = this.stateVector[c].size();
                int[][] contig = new int[rows][cols];
                int n = 0;
                int sample = 0;
                while (sample < this.theAlignment.getSequenceCount()) {
                    if (S[sample][r] != -99 && S[sample][c] != -99) {
                        int[] nArray = contig[S[sample][r]];
                        byte by = S[sample][c];
                        nArray[by] = nArray[by] + 1;
                        ++n;
                    }
                    ++sample;
                }
                if (rows == 2 && cols == 2) {
                    this.diseq[r][c] = this.calculateRSqrDisequilibrium(contig[0][0], contig[1][0], contig[0][1], contig[1][1]);
                    this.diseq[c][r] = this.calculateDisequilibrium(contig[0][0], contig[1][0], contig[0][1], contig[1][1]);
                    this.pDiseq[r][c] = n;
                    this.pDiseq[c][r] = fisherExact.getCumlativeP(contig[0][0], contig[1][0], contig[0][1], contig[1][1]);
                } else {
                    this.diseq[r][c] = this.calculateRSqrDisequilibrium(contig, rows, cols);
                    this.diseq[c][r] = this.calculateDisequilibrium(contig, rows, cols);
                    contigencyTable.setMatrix(contig);
                    this.pDiseq[r][c] = n;
                    this.pDiseq[c][r] = this.rapidPermute ? contigencyTable.calcRapidMonteCarloExactTest(this.numberOfPermutations) : contigencyTable.calcMonteCarloExactTest(this.numberOfPermutations);
                }
                ++c;
            }
            ++r;
        }
    }

    double calculateDisequilibrium(int countAA, int countAa, int countaA, int countaa) {
        double nonmissingSampleSize = countAA + countAa + countaA + countaa;
        double countR = countaa + countAa;
        double countC = countaa + countaA;
        double freqR = (nonmissingSampleSize - countR) / nonmissingSampleSize;
        double freqC = (nonmissingSampleSize - countC) / nonmissingSampleSize;
        if (freqR == 0.0 || freqC == 0.0 || freqR == 1.0 || freqC == 1.0) {
            return -999.0;
        }
        double freq = (double)countAA / nonmissingSampleSize - freqR * freqC;
        if (freq < 0.0) {
            return freq / Math.max(-freqR * freqC, -(1.0 - freqR) * (1.0 - freqC));
        }
        return freq / Math.min((1.0 - freqR) * freqC, (1.0 - freqC) * freqR);
    }

    double calculateRSqrDisequilibrium(int countAB, int countAb, int countaB, int countab) {
        double nonmissingSampleSize = countAB + countAb + countaB + countab;
        double freqA = (double)(countAB + countAb) / nonmissingSampleSize;
        double freqB = (double)(countAB + countaB) / nonmissingSampleSize;
        if (freqA == 0.0 || freqB == 0.0 || freqA == 1.0 || freqB == 1.0) {
            return Double.NaN;
        }
        double rsqr = (double)countAB / nonmissingSampleSize * ((double)countab / nonmissingSampleSize);
        rsqr -= (double)countaB / nonmissingSampleSize * ((double)countAb / nonmissingSampleSize);
        rsqr *= rsqr;
        return rsqr /= freqA * (1.0 - freqA) * freqB * (1.0 - freqB);
    }

    double calculateDisequilibrium(int[][] contig, int rows, int cols) {
        double D_prime = 0.0;
        double nonmissingSampleSize = 0.0;
        double[] p_margin = new double[rows];
        double[] q_margin = new double[cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                nonmissingSampleSize += (double)contig[i][j];
                int n = i;
                p_margin[n] = p_margin[n] + (double)contig[i][j];
                int n2 = j;
                q_margin[n2] = q_margin[n2] + (double)contig[i][j];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < rows) {
            if (p_margin[i2] != 0.0) {
                double pi = p_margin[i2] / nonmissingSampleSize;
                int j = 0;
                while (j < cols) {
                    if (q_margin[j] != 0.0) {
                        double qj = q_margin[j] / nonmissingSampleSize;
                        double Dij = (double)contig[i2][j] / nonmissingSampleSize - pi * qj;
                        double Dmax = Dij < 0.0 ? Math.min(pi * qj, (1.0 - pi) * (1.0 - qj)) : Math.min(pi * (1.0 - qj), (1.0 - pi) * qj);
                        double D_prime_ij = Dij / Dmax;
                        D_prime += pi * qj * Math.abs(D_prime_ij);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return D_prime;
    }

    double calculateRSqrDisequilibrium(int[][] contig, int rows, int cols) {
        double r_sqrsum = 0.0;
        int nonmissingSampleSize = 0;
        int[] p_margin = new int[rows];
        int[] q_margin = new int[cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                nonmissingSampleSize += contig[i][j];
                int n = i;
                p_margin[n] = p_margin[n] + contig[i][j];
                int n2 = j;
                q_margin[n2] = q_margin[n2] + contig[i][j];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < rows) {
            if (p_margin[i2] != 0) {
                double pi = (double)p_margin[i2] / (double)nonmissingSampleSize;
                int j = 0;
                while (j < cols) {
                    if (q_margin[j] != 0) {
                        double qj = (double)q_margin[j] / (double)nonmissingSampleSize;
                        int countAB = contig[i2][j];
                        int countAb = p_margin[i2] - countAB;
                        int countaB = q_margin[j] - countAB;
                        int countab = nonmissingSampleSize - countAB - countAb - countaB;
                        r_sqrsum += pi * qj * this.calculateRSqrDisequilibrium(countAB, countAb, countaB, countab);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return r_sqrsum;
    }

    public double getP(int r, int c) {
        if (r <= c) {
            return this.pDiseq[r][c];
        }
        return this.pDiseq[c][r];
    }

    public int getN(int r, int c) {
        if (c <= r) {
            return (int)this.pDiseq[r][c];
        }
        return (int)this.pDiseq[c][r];
    }

    public double getDPrime(int r, int c) {
        if (r <= c) {
            return this.diseq[r][c];
        }
        return this.diseq[c][r];
    }

    public double getRSqr(int r, int c) {
        if (c <= r) {
            return this.diseq[r][c];
        }
        return this.diseq[c][r];
    }

    public int getSiteCount() {
        return this.theAlignment.getSiteCount();
    }

    public AnnotationAlignment getAnnotatedAlignment() {
        return this.theAnnotationAlignment;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(this, new PrintWriter(sw));
        return sw.toString();
    }

    public void print(LinkageDisequilibrium ld, PrintWriter out) {
        String cState;
        int c;
        String rState;
        int r;
        if (this.annotated) {
            out.print("LocusName1\t Chromosome1\t ChromoPosition1\t ");
            out.print("Site1\t NumberOfStates1\t States1\t Frequency1\t ");
            out.print("LocusName2\t Chromosome2\t ChromoPosition2\t ");
            out.print("Site2\t NumberOfStates2\t States2\t Frequency2\t ");
            out.print("R^2\t DPrime\t pDiseq\t N");
            out.println();
            r = 0;
            while (r < this.theAlignment.getSiteCount()) {
                rState = this.getStatesForPrint(r);
                c = 0;
                while (c <= r) {
                    cState = this.getStatesForPrint(c);
                    out.print(this.theAnnotationAlignment.getLocusName(r) + "\t" + this.theAnnotationAlignment.getChromosome(r) + "\t" + this.theAnnotationAlignment.getChromosomePosition(r) + "\t");
                    out.print(this.theAnnotationAlignment.getLocusPosition(r) + "\t" + this.stateVector[r].size() + "\t" + rState + "\t" + "NotDone" + "\t");
                    out.print(this.theAnnotationAlignment.getLocusName(c) + "\t" + this.theAnnotationAlignment.getChromosome(c) + "\t" + this.theAnnotationAlignment.getChromosomePosition(c) + "\t");
                    out.print(this.theAnnotationAlignment.getLocusPosition(c) + "\t" + this.stateVector[c].size() + "\t" + cState + "\t" + "NotDone" + "\t");
                    out.print(ld.getRSqr(r, c) + "\t" + ld.getDPrime(r, c) + "\t" + ld.getP(r, c) + "\t" + ld.getN(r, c));
                    out.println();
                    ++c;
                }
                ++r;
            }
        } else {
            out.print("Site1\t NumberOfStates1\t States1\t Frequency1\t ");
            out.print("Site2\t NumberOfStates2\t States2\t Frequency2\t ");
            out.print("R^2\t DPrime\t pDiseq\t N");
            out.println();
            r = 0;
            while (r < this.theAlignment.getSiteCount()) {
                rState = this.getStatesForPrint(r);
                c = 0;
                while (c <= r) {
                    cState = this.getStatesForPrint(c);
                    out.print(r + "\t" + this.stateVector[r].size() + "\t" + rState + "\t" + "NotDone" + "\t");
                    out.print(c + "\t" + this.stateVector[c].size() + "\t" + cState + "\t" + "NotDone" + "\t");
                    out.print(ld.getRSqr(r, c) + "\t" + ld.getDPrime(r, c) + "\t" + ld.getP(r, c) + "\t" + ld.getN(r, c));
                    out.println();
                    ++c;
                }
                ++r;
            }
        }
        out.println();
        out.println("Taxa Included:");
        int i = 0;
        while (i < this.theAlignment.getSequenceCount()) {
            out.println(this.theAlignment.getIdentifier(i).getName());
            ++i;
        }
    }

    private String getStatesForPrint(int site) {
        String s = "[";
        DataType dt = this.annotated ? this.theAnnotationAlignment.getDataType(site) : this.theAlignment.getDataType();
        if (dt.getDescription().equals("Numeric")) {
            int i = 0;
            while (i < this.stateVector[site].size()) {
                Character C = (Character)this.stateVector[site].get(i);
                s = s + dt.getState(C.charValue()) + " ";
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.stateVector[site].size()) {
                Character C = (Character)this.stateVector[site].get(i);
                s = s + C.toString() + " ";
                ++i;
            }
        }
        s = s + "]";
        return s;
    }

    public Object[] getTableColumnNames() {
        Object[] basicLabels = new String[]{"Site1", "NumberOfStates1", "States1", "Frequency1", "Site2", "NumberOfStates2", "States2", "Frequency2", "R^2", "DPrime", "pDiseq", "N"};
        Object[] annotatedLabels = new String[]{"LocusName1", "Chromosome1", "ChromoPosition1", "Site1", "NumberOfStates1", "States1", "Frequency1", "LocusName2", "Chromosome2", "ChromoPosition2", "Site2", "NumberOfStates2", "States2", "Frequency2", "R^2", "DPrime", "pDiseq", "N"};
        if (this.annotated) {
            return annotatedLabels;
        }
        return basicLabels;
    }

    public Object[][] getTableData() {
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(8);
        int i = 0;
        int total = this.theAlignment.getSiteCount() * (this.theAlignment.getSiteCount() - 1) / 2;
        Object[][] data = this.annotated ? new String[total][18] : new String[total][12];
        int r = 0;
        while (r < this.theAlignment.getSiteCount()) {
            String rState = this.getStatesForPrint(r);
            int c = 0;
            while (c < r) {
                String cState = this.getStatesForPrint(c);
                int labelOffset = 0;
                if (this.annotated) {
                    data[i][labelOffset++] = this.theAnnotationAlignment.getLocusName(r);
                    data[i][labelOffset++] = "" + this.theAnnotationAlignment.getChromosome(r);
                    data[i][labelOffset++] = this.theAnnotationAlignment.getLocusName(r);
                    data[i][labelOffset++] = "" + this.theAnnotationAlignment.getLocusPosition(r);
                } else {
                    data[i][labelOffset++] = "" + r;
                }
                data[i][labelOffset++] = "" + this.stateVector[r].size();
                data[i][labelOffset++] = "" + rState;
                data[i][labelOffset++] = "NotImplemented";
                if (this.annotated) {
                    data[i][labelOffset++] = this.theAnnotationAlignment.getLocusName(c);
                    data[i][labelOffset++] = "" + this.theAnnotationAlignment.getChromosome(c);
                    data[i][labelOffset++] = this.theAnnotationAlignment.getLocusName(c);
                    data[i][labelOffset++] = "" + this.theAnnotationAlignment.getLocusPosition(c);
                } else {
                    data[i][labelOffset++] = "" + c;
                }
                data[i][labelOffset++] = "" + this.stateVector[c].size();
                data[i][labelOffset++] = "" + cState;
                data[i][labelOffset++] = "NotImplemented";
                data[i][labelOffset++] = nf.format(this.getRSqr(r, c));
                data[i][labelOffset++] = nf.format(this.getDPrime(r, c));
                data[i][labelOffset++] = nf.format(this.getP(r, c));
                data[i][labelOffset++] = "" + this.getN(r, c);
                ++i;
                ++c;
            }
            ++r;
        }
        return data;
    }

    public String getTableTitle() {
        return "Linkage Disequilibrium";
    }
}

