/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.util.HeapSort;

public class DiscreteStatistics {
    public static double mean(double[] x) {
        double m = 0.0;
        int len = x.length;
        int i = 0;
        while (i < len) {
            m += x[i];
            ++i;
        }
        return m / (double)len;
    }

    public static double variance(double[] x, double mean) {
        double var = 0.0;
        int len = x.length;
        int i = 0;
        while (i < len) {
            double diff = x[i] - mean;
            var += diff * diff;
            ++i;
        }
        int n = len < 2 ? 1 : len - 1;
        return var / (double)n;
    }

    public static double skewness(double[] x) {
        double mean = DiscreteStatistics.mean(x);
        double stdev = DiscreteStatistics.stdev(x);
        double skew = 0.0;
        double len = x.length;
        int i = 0;
        while (i < x.length) {
            double diff = x[i] - mean;
            skew += (diff /= stdev) * diff * diff;
            ++i;
        }
        return skew *= len / ((len - 1.0) * (len - 2.0));
    }

    public static double stdev(double[] x) {
        return Math.sqrt(DiscreteStatistics.variance(x));
    }

    public static double variance(double[] x) {
        double m = DiscreteStatistics.mean(x);
        return DiscreteStatistics.variance(x, m);
    }

    public static double varianceSampleMean(double[] x, double mean) {
        return DiscreteStatistics.variance(x, mean) / (double)x.length;
    }

    public static double varianceSampleMean(double[] x) {
        return DiscreteStatistics.variance(x) / (double)x.length;
    }

    public static double quantile(double q, double[] x, int[] indices) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Quantile out of range");
        }
        if (q == 0.0) {
            return x[indices[0]] - 1.0;
        }
        return x[indices[(int)Math.ceil(q * (double)x.length) - 1]];
    }

    public static double quantile(double q, double[] x) {
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        return DiscreteStatistics.quantile(q, x, indices);
    }

    public static double cdf(double z, double[] x, int[] indices) {
        int i = 0;
        while (i < x.length) {
            if (x[indices[i]] > z) break;
            ++i;
        }
        return (double)i / (double)x.length;
    }

    public static double cdf(double z, double[] x) {
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        return DiscreteStatistics.cdf(z, x, indices);
    }
}

