/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

public class ParetoDistribution {
    public static double pdf(double x, double k, double m) {
        return k * Math.pow(m, k) * Math.pow(x, -(k + 1.0));
    }

    public static double cdf(double x, double k, double m) {
        return 1.0 - Math.pow(m / x, k);
    }

    public static double quantile(double p, double k, double m) {
        return m / Math.pow(1.0 - p, 1.0 / k);
    }

    public static double mean(double k, double m) {
        if (k > 1.0) {
            return m * k / (k - 1.0);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double variance(double k, double m) {
        if (k > 2.0) {
            return m * m * k / ((k - 1.0) * (k - 1.0) * (k - 2.0));
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double moment(int n, double k, double m) {
        if (k > (double)n) {
            return Math.pow(m, n) * k / (k - (double)n);
        }
        return Double.POSITIVE_INFINITY;
    }
}

