/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import java.io.PrintWriter;
import pal.io.FormattedOutput;
import pal.math.MersenneTwisterFast;
import pal.misc.Report;
import pal.statistics.DiscreteStatistics;

public class ShimodairaHasegawaTest
implements Report {
    public int bestH;
    public double[] delta;
    public double[] pval;
    public int numBootstraps;

    public void compare(double[][] sLogL, int numBoot) {
        this.shtest(sLogL, null, numBoot);
    }

    public void compare(double[][] pLogL, int[] alias, int numBoot) {
        this.shtest(pLogL, alias, numBoot);
    }

    public void report(PrintWriter out) {
        FormattedOutput fo = FormattedOutput.getInstance();
        out.println("SHIMODAIRA-HASEGAWA TEST (" + this.numBootstraps + " bootstraps):");
        out.println();
        out.println("tree\tdeltaL\tpval");
        out.println("--------------------------");
        int i = 0;
        while (i < this.pval.length) {
            out.print(i + 1 + "\t");
            fo.displayDecimal(out, this.delta[i], 2);
            out.print("\t");
            fo.displayDecimal(out, this.pval[i], 4);
            if (this.pval[i] < 0.05) {
                out.println(" **");
            } else {
                out.println();
            }
            ++i;
        }
        out.println();
        out.println("** indicates a tree that is significantly worse than the ML tree (5% level)");
    }

    private void shtest(double[][] pLogL, int[] alias, int numBoot) {
        int j;
        int numH = pLogL.length;
        this.numBootstraps = numBoot;
        this.delta = new double[numH];
        this.pval = new double[numH];
        int numSites = alias == null ? pLogL[0].length : alias.length;
        double[] logL = new double[numH];
        int i = 0;
        while (i < numSites) {
            int p = alias == null ? i : alias[i];
            int j2 = 0;
            while (j2 < numH) {
                int n = j2;
                logL[n] = logL[n] + pLogL[j2][p];
                ++j2;
            }
            ++i;
        }
        this.bestH = 0;
        double maxLogL = logL[0];
        int i2 = 1;
        while (i2 < numH) {
            if (logL[i2] > maxLogL) {
                this.bestH = i2;
                maxLogL = logL[i2];
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < numH) {
            this.delta[i3] = logL[this.bestH] - logL[i3];
            ++i3;
        }
        double[][] rs = new double[numH][numBoot];
        MersenneTwisterFast mt = new MersenneTwisterFast();
        int i4 = 0;
        while (i4 < numBoot) {
            int j3 = 0;
            while (j3 < numSites) {
                int s = mt.nextInt(numSites);
                int p = alias == null ? s : alias[s];
                int k = 0;
                while (k < numH) {
                    double[] dArray = rs[k];
                    int n = i4;
                    dArray[n] = dArray[n] + pLogL[k][p];
                    ++k;
                }
                ++j3;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < numH) {
            double m = DiscreteStatistics.mean(rs[i5]);
            int j4 = 0;
            while (j4 < numBoot) {
                rs[i5][j4] = rs[i5][j4] - m;
                ++j4;
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < numBoot) {
            double max = this.findMaxInColumn(rs, i6);
            j = 0;
            while (j < numH) {
                rs[j][i6] = max - rs[j][i6];
                ++j;
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < numH) {
            int count = 0;
            j = 0;
            while (j < numBoot) {
                if (rs[i7][j] >= this.delta[i7]) {
                    ++count;
                }
                ++j;
            }
            this.pval[i7] = (double)count / (double)numBoot;
            ++i7;
        }
        rs = null;
        logL = null;
    }

    private double findMaxInColumn(double[][] array, int column) {
        int len = array.length;
        int best = 0;
        double max = array[0][column];
        int i = 1;
        while (i < len) {
            if (array[i][column] > max) {
                best = i;
                max = array[i][column];
            }
            ++i;
        }
        return max;
    }
}

