/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.substmodel.NucleotideModel;
import pal.util.XMLConstants;

public class HKY
extends NucleotideModel
implements Serializable,
XMLConstants {
    private boolean showSE;
    private double kappa;
    private double kappaSE;

    public HKY(double kappa, double[] freq) {
        super(freq);
        this.kappa = kappa;
        this.makeHKY();
        this.fromQToR();
        this.showSE = false;
    }

    public HKY(double[] params, double[] freq) {
        this(params[0], freq);
    }

    public Object clone() {
        return new HKY(this);
    }

    private HKY(HKY hky) {
        this(hky.kappa, hky.frequency);
    }

    public int getModelID() {
        return 2;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: HKY (Hasegawa et al. 1985)");
        out.print("Transition/transversion rate ratio kappa: ");
        this.format.displayDecimal(out, this.kappa, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.kappaSE, 2);
            out.print(")");
        }
        out.println();
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
    }

    public int getNumParameters() {
        return 1;
    }

    public void setParameter(double param, int n) {
        this.kappa = param;
        this.makeHKY();
        this.fromQToR();
    }

    public double getParameter(int n) {
        return this.kappa;
    }

    public void setParameterSE(double paramSE, int n) {
        this.kappaSE = paramSE;
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 1.0E-4;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public double getDefaultValue(int n) {
        return 4.0;
    }

    public String getParameterName(int i) {
        if (i == 0) {
            return "kappa";
        }
        return "unknown";
    }

    public String getUniqueName() {
        return "HKY";
    }

    private void makeHKY() {
        this.rate[0][1] = 1.0;
        this.rate[0][2] = this.kappa;
        this.rate[0][3] = 1.0;
        this.rate[1][2] = 1.0;
        this.rate[1][3] = this.kappa;
        this.rate[2][3] = 1.0;
    }
}

