/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.datatype.Nucleotides;
import pal.substmodel.AbstractRateMatrix;
import pal.substmodel.F81;
import pal.substmodel.F84;
import pal.substmodel.GTR;
import pal.substmodel.HKY;
import pal.substmodel.RateMatrix;
import pal.substmodel.TN;

public abstract class NucleotideModel
extends AbstractRateMatrix
implements RateMatrix,
Serializable {
    private double expectedTsTvRatio;
    private double expectedYRTsRatio;

    public static NucleotideModel getInstance(int modelID, double[] params, double[] freq) {
        if (modelID == 0) {
            return new GTR(params, freq);
        }
        if (modelID == 1) {
            return new TN(params, freq);
        }
        if (modelID == 2) {
            return new HKY(params, freq);
        }
        if (modelID == 3) {
            return new F84(params, freq);
        }
        if (modelID == 4) {
            return new F81(freq);
        }
        return new F81(freq);
    }

    protected NucleotideModel(double[] f) {
        super(4);
        this.dataType = new Nucleotides();
        this.setFrequencies(f);
    }

    protected void printFrequencies(PrintWriter out) {
        out.println("Nucleotide frequencies:");
        super.printFrequencies(out);
    }

    protected void printRatios(PrintWriter out) {
        this.computeRatios();
        out.print("Expected transition/transversion ratio: ");
        this.format.displayDecimal(out, this.expectedTsTvRatio, 2);
        out.println();
        out.print("Expected pyrimidine transition/purine transition ratio: ");
        this.format.displayDecimal(out, this.expectedYRTsRatio, 2);
        out.println();
    }

    private void computeRatios() {
        int A = 0;
        double piA = this.frequency[0];
        int C = 1;
        double piC = this.frequency[1];
        int G = 2;
        double piG = this.frequency[2];
        int T = 3;
        double piT = this.frequency[3];
        double numYTs = piC * this.rate[C][T] + piT * this.rate[T][C];
        double numRTs = piA * this.rate[A][G] + piG * this.rate[G][A];
        double numTv = piA * this.rate[A][C] + piC * this.rate[C][A] + piA * this.rate[A][T] + piT * this.rate[T][A] + piC * this.rate[C][G] + piG * this.rate[G][C] + piG * this.rate[G][T] + piT * this.rate[T][G];
        this.expectedTsTvRatio = (numYTs + numRTs) / numTv;
        this.expectedYRTsRatio = numYTs / numRTs;
    }
}

