/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.Serializable;
import pal.misc.ExternalParameterListener;
import pal.misc.ParameterEvent;
import pal.misc.ParameterizedDouble;
import pal.misc.TimeOrderCharacterData;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.ParameterizedTree;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class DatedTipsClockTree
extends ParameterizedTree
implements ExternalParameterListener,
Serializable {
    public static final int PARAMETERIZE_WITH_DEFAULTS = 0;
    public static final int PARAMETERIZE_WITH_GIVEN = 1;
    public static final int NO_PARAMETRIZE = 2;
    private double[] parameter;
    private ParameterizedDouble rate;
    private double minDate;
    private double maxDate;
    private double[] date;
    private TimeOrderCharacterData tocd;
    private int internalHeightMode_;
    private int rateMode_;

    public DatedTipsClockTree(Tree t) {
        this(t, null, true);
    }

    public DatedTipsClockTree(Tree t, TimeOrderCharacterData tocd, boolean useDefaultParameters) {
        this(t, new ParameterizedDouble(0.0, 0.0, 1.0), tocd, useDefaultParameters ? 0 : 1, useDefaultParameters ? 0 : 1);
    }

    public DatedTipsClockTree(Tree t, ParameterizedDouble rate, TimeOrderCharacterData tocd, int internalHeightMode, int rateMode) {
        this.rateMode_ = rateMode;
        this.internalHeightMode_ = internalHeightMode;
        this.rate = rate;
        this.setBaseTree(t);
        this.tocd = tocd;
        if (this.getRoot().getChildCount() < 2) {
            throw new IllegalArgumentException("The root node must have at least two childs!");
        }
        switch (internalHeightMode) {
            case 0: {
                this.parameter = new double[this.getInternalNodeCount()];
                int i = 0;
                while (i < this.parameter.length) {
                    this.parameter[i] = this.getDefaultValue(i);
                    ++i;
                }
                break;
            }
            case 1: {
                this.parameter = new double[this.getInternalNodeCount()];
                this.heights2parameters();
                break;
            }
            case 2: {
                this.parameter = new double[0];
            }
        }
        this.date = new double[t.getExternalNodeCount()];
        this.getDates();
        if (rateMode == 0) {
            boolean found = false;
            int i = 0;
            while (i < this.getExternalNodeCount()) {
                String name = this.getExternalNode(i).getIdentifier().getName();
                int index = tocd.whichIdNumber(name);
                double time = tocd.getTime(index);
                if (time > 0.0) {
                    double height = this.getExternalNode(i).getNodeHeight();
                    rate.setValue(height / time);
                    System.out.println("rate = " + rate);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                rate.setValue(0.0);
            }
        }
        if (rateMode == 2) {
            rate.addExternalParameterListener(this);
        }
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public void parameterChanged(ParameterEvent pe) {
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public void update() {
        this.getDates();
        NodeUtils.lengths2Heights(this.getRoot());
        this.heights2parameters();
    }

    public int getNumParameters() {
        return (this.internalHeightMode_ == 2 ? 0 : this.getInternalNodeCount()) + (this.rateMode_ == 2 ? 0 : 1);
    }

    private final boolean isHeightParameter(int n) {
        return this.internalHeightMode_ != 2 && n < this.getInternalNodeCount();
    }

    public void setParameter(double param, int n) {
        if (this.isHeightParameter(n)) {
            this.parameter[n] = param;
        } else if (this.rateMode_ != 2) {
            this.rate.setValue(param);
        } else {
            throw new RuntimeException("Assertion error : Illegal attempt to change rate parameter");
        }
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public double getParameter(int n) {
        if (this.isHeightParameter(n)) {
            return this.parameter[n];
        }
        return this.rate.getValue();
    }

    public void setParameterSE(double paramSE, int n) {
        if (!this.isHeightParameter(n)) {
            this.rate.setSE(paramSE);
        }
    }

    public double getParameterSE(int n) {
        if (this.isHeightParameter(n)) {
            return 0.0;
        }
        return this.rate.getSE();
    }

    public double getLowerLimit(int n) {
        if (this.isHeightParameter(n)) {
            return 1.0E-9;
        }
        return this.rate.getLowerLimit();
    }

    public double getUpperLimit(int n) {
        if (this.isHeightParameter(n)) {
            return 100.0;
        }
        return this.rate.getUpperLimit();
    }

    public double getDefaultValue(int n) {
        if (this.isHeightParameter(n)) {
            return 0.04;
        }
        return this.rate.getDefaultValue();
    }

    private void updateRateStuff() {
        double rateValue = this.rate.getValue();
        int numberOfExternalNodes = this.getExternalNodeCount();
        int i = 0;
        while (i < numberOfExternalNodes) {
            Node leaf = this.getExternalNode(i);
            double h = (this.maxDate - this.date[i]) * rateValue;
            System.out.println("H:" + h);
            leaf.setNodeHeight(Math.abs(h));
            double hp = leaf.getParent().getNodeHeight();
            leaf.setBranchLength(Math.abs(hp - h));
            ++i;
        }
    }

    public void setRate(double r) {
        this.rate.setValue(r);
        if (this.rateMode_ != 2) {
            this.updateRateStuff();
        }
    }

    public double getRate() {
        return this.rate.getValue();
    }

    public void setRateSE(double rSE) {
        this.rate.setSE(rSE);
    }

    public double getMaxRate() {
        double maxRate = 0.0;
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            Node leaf = this.getExternalNode(i);
            double maxRateLeaf = (leaf.getParent().getNodeHeight() - 1.0E-9) / (this.maxDate - this.date[i]);
            if (i == 0 || maxRateLeaf < maxRate) {
                maxRate = maxRateLeaf;
            }
            ++i;
        }
        return maxRate;
    }

    public TimeOrderCharacterData getTimeOrderCharacterData() {
        if (this.tocd != null) {
            return this.tocd;
        }
        TimeOrderCharacterData tempTOCD = new TimeOrderCharacterData(TreeUtils.getLeafIdGroup(this), 0);
        tempTOCD.setTimes(this.date, 0, true);
        return tempTOCD;
    }

    private void parameters2Heights() {
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            this.getExternalNode(i).setNodeHeight((this.maxDate - this.date[i]) * this.rate.getValue());
            ++i;
        }
        if (this.internalHeightMode_ != 2) {
            int i2 = 0;
            while (i2 < this.getInternalNodeCount()) {
                Node node = this.getInternalNode(i2);
                node.setNodeHeight(this.parameter[i2] + NodeUtils.findLargestChild(node));
                ++i2;
            }
        }
    }

    private void heights2parameters() {
        int i = 0;
        while (i < this.getInternalNodeCount()) {
            Node inode = this.getInternalNode(i);
            this.parameter[i] = inode.getNodeHeight() - NodeUtils.findLargestChild(inode);
            ++i;
        }
    }

    private void getDates() {
        int i;
        double maxTime = 0.0;
        if (this.tocd != null) {
            i = 0;
            while (i < this.date.length) {
                if (this.tocd.getTime(i) > maxTime) {
                    maxTime = this.tocd.getTime(i);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.getExternalNodeCount()) {
            if (this.tocd == null) {
                this.date[i] = this.extractDate(this.getExternalNode(i).getIdentifier().getName());
            } else if (this.tocd.hasTimes()) {
                String name = this.getExternalNode(i).getIdentifier().getName();
                int index = this.tocd.whichIdNumber(name);
                this.date[i] = maxTime - this.tocd.getTime(index);
            } else {
                throw new IllegalArgumentException("TimeOrderCharacterData does not have any times!");
            }
            ++i;
        }
        this.minDate = this.maxDate = this.date[0];
        int i2 = 1;
        while (i2 < this.getExternalNodeCount()) {
            if (this.date[i2] > this.maxDate) {
                this.maxDate = this.date[i2];
            }
            if (this.date[i2] < this.minDate) {
                this.minDate = this.date[i2];
            }
            ++i2;
        }
        if (this.minDate == this.maxDate) {
            throw new IllegalArgumentException("Tip dates must not be the same for all tips");
        }
    }

    private double extractDate(String string) {
        StringBuffer buffer = new StringBuffer();
        int len = string.length();
        boolean readDot = false;
        int i = len - 1;
        while (i > -1) {
            char c = string.charAt(i);
            if (!Character.isDigit(c) && (c != '.' || readDot)) break;
            buffer.append(c);
            if (c == '.') {
                readDot = true;
            }
            --i;
        }
        buffer.reverse();
        String date = buffer.toString();
        if (date.length() == 0) {
            return 0.0;
        }
        return Double.valueOf(buffer.toString());
    }

    static {
        PARAMETERIZE_WITH_DEFAULTS = 0;
        PARAMETERIZE_WITH_GIVEN = 1;
        NO_PARAMETRIZE = 2;
    }
}

