/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.mep.MutationRateModel;
import pal.misc.TimeOrderCharacterData;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.ParameterizedTree;
import pal.tree.Tree;

public class MutationRateModelTree
extends ParameterizedTree {
    TimeOrderCharacterData tocd = null;
    MutationRateModel model = null;
    int numParameters;
    private double MIN_MU = 1.0E-12;
    private double MIN_DELTA = 1.0E-12;
    private double lnL = 0.0;
    private double[] parameter;

    public MutationRateModelTree(Tree t, TimeOrderCharacterData tocd, MutationRateModel model) throws RuntimeException {
        this.setBaseTree(t);
        this.tocd = tocd;
        this.model = model;
        if (t.getRoot().getChildCount() < 2) {
            throw new RuntimeException("The root node must have at least two childs!");
        }
        NodeUtils.heights2Lengths(this.getRoot());
        this.numParameters = this.getInternalNodeCount() + model.getNumParameters();
        if (!tocd.hasTimes()) {
            throw new RuntimeException("Must have times!");
        }
        this.parameter = new double[this.numParameters - model.getNumParameters()];
        this.heights2parameters();
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public void setParameter(double param, int n) {
        if (n < this.getInternalNodeCount()) {
            this.parameter[n] = param;
        } else {
            this.model.setParameter(param, n - this.getInternalNodeCount());
        }
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public double getParameter(int n) {
        if (n < this.getInternalNodeCount()) {
            return this.parameter[n];
        }
        return this.model.getParameter(n - this.getInternalNodeCount());
    }

    public double getLowerLimit(int n) {
        if (n < this.getInternalNodeCount()) {
            return 1.0E-9;
        }
        return this.MIN_MU;
    }

    public double getDefaultValue(int n) {
        return 0.04;
    }

    public void setParameterSE(double paramSE, int n) {
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public MutationRateModel getMutationRateModel() {
        return this.model;
    }

    protected void parameters2Heights() {
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            int index = this.tocd.whichIdNumber(this.getExternalNode(i).getIdentifier().getName());
            this.getExternalNode(i).setNodeHeight(this.model.getExpectedSubstitutions(this.tocd.getTime(index)));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getInternalNodeCount()) {
            Node node = this.getInternalNode(i2);
            node.setNodeHeight(this.parameter[i2] + NodeUtils.findLargestChild(node));
            ++i2;
        }
    }

    protected void heights2parameters() {
        int i = 0;
        while (i < this.getInternalNodeCount()) {
            Node node = this.getInternalNode(i);
            this.parameter[i] = node.getNodeHeight() - NodeUtils.findLargestChild(node);
            ++i;
        }
    }

    public void setLnL(double lnL) {
        this.lnL = lnL;
    }

    public double getLnL() {
        return this.lnL;
    }
}

