/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import pal.misc.Identifier;
import pal.misc.LabelMapping;
import pal.tree.AttributeNode;
import pal.tree.Node;
import pal.tree.NodeUtils;

public class SimpleNode
implements AttributeNode {
    private Node parent;
    private int number;
    private byte[] sequence;
    private double length;
    private double lengthSE;
    private double height;
    private Identifier identifier;
    private Hashtable attributes = null;
    private Node[] child;
    static final long serialVersionUID = 3472432765038556717L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(3);
        out.writeObject(this.parent);
        out.writeInt(this.number);
        out.writeObject(this.sequence);
        out.writeDouble(this.length);
        out.writeDouble(this.lengthSE);
        out.writeDouble(this.height);
        out.writeObject(this.identifier);
        out.writeObject(this.child);
        out.writeObject(this.attributes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.parent = (Node)in.readObject();
                this.number = in.readInt();
                this.sequence = (byte[])in.readObject();
                double[][][] partial = (double[][][])in.readObject();
                this.length = in.readDouble();
                this.lengthSE = in.readDouble();
                this.height = in.readDouble();
                in.readDouble();
                this.identifier = (Identifier)in.readObject();
                this.child = (Node[])in.readObject();
                break;
            }
            case 2: {
                this.parent = (Node)in.readObject();
                this.number = in.readInt();
                this.sequence = (byte[])in.readObject();
                this.length = in.readDouble();
                this.lengthSE = in.readDouble();
                this.height = in.readDouble();
                this.identifier = (Identifier)in.readObject();
                this.child = (Node[])in.readObject();
                break;
            }
            default: {
                this.parent = (Node)in.readObject();
                this.number = in.readInt();
                this.sequence = (byte[])in.readObject();
                this.length = in.readDouble();
                this.lengthSE = in.readDouble();
                this.height = in.readDouble();
                this.identifier = (Identifier)in.readObject();
                this.child = (Node[])in.readObject();
                this.attributes = (Hashtable)in.readObject();
            }
        }
    }

    public SimpleNode() {
        this.parent = null;
        this.child = null;
        this.length = 0.0;
        this.lengthSE = 0.0;
        this.height = 0.0;
        this.identifier = Identifier.ANONYMOUS;
        this.number = 0;
        this.sequence = null;
    }

    public SimpleNode(String name, double branchLength) {
        this();
        this.identifier = new Identifier(name);
        this.length = branchLength;
    }

    public SimpleNode(Node n) {
        this(n, true);
    }

    public void reset() {
        this.parent = null;
        this.child = null;
        this.length = 0.0;
        this.lengthSE = 0.0;
        this.height = 0.0;
        this.identifier = Identifier.ANONYMOUS;
        this.number = 0;
        this.sequence = null;
    }

    public SimpleNode(Node n, boolean keepIds) {
        this.init(n, keepIds);
        int i = 0;
        while (i < n.getChildCount()) {
            this.addChild(new SimpleNode(n.getChild(i), keepIds));
            ++i;
        }
    }

    public SimpleNode(Node n, LabelMapping lm) {
        this.init(n, true, lm);
        int i = 0;
        while (i < n.getChildCount()) {
            this.addChild(new SimpleNode(n.getChild(i), lm));
            ++i;
        }
    }

    protected void init(Node n) {
        this.init(n, true);
    }

    protected void init(Node n, boolean keepId) {
        this.init(n, keepId, null);
    }

    protected void init(Node n, boolean keepId, LabelMapping lm) {
        this.parent = null;
        this.length = n.getBranchLength();
        this.lengthSE = n.getBranchLengthSE();
        this.height = n.getNodeHeight();
        this.identifier = keepId ? (lm != null ? lm.getLabelIdentifier(n.getIdentifier()) : n.getIdentifier()) : Identifier.ANONYMOUS;
        this.number = n.getNumber();
        this.sequence = n.getSequence();
        if (n instanceof AttributeNode) {
            AttributeNode attNode = (AttributeNode)n;
            Enumeration e = attNode.getAttributeNames();
            while (e != null && e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.setAttribute(name, attNode.getAttribute(name));
            }
        }
        this.child = null;
    }

    public final Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public final void removeParent() {
        this.parent = null;
    }

    public String getSequenceString() {
        return new String(this.sequence);
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public void setSequence(byte[] s) {
        this.sequence = s;
    }

    public final double getBranchLength() {
        return this.length;
    }

    public final void setBranchLength(double value) {
        this.length = value;
    }

    public final double getBranchLengthSE() {
        return this.lengthSE;
    }

    public final void setBranchLengthSE(double value) {
        this.lengthSE = value;
    }

    public final double getNodeHeight() {
        return this.height;
    }

    public final void setNodeHeight(double value) {
        this.height = Math.abs(value);
    }

    public final Identifier getIdentifier() {
        return this.identifier;
    }

    public final Identifier setIdentifier(Identifier id) {
        this.identifier = id;
        return this.identifier;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getNumber() {
        return this.number;
    }

    public Node getChild(int n) {
        return this.child[n];
    }

    public void setChild(int n, Node node) {
        this.child[n] = node;
        this.child[n].setParent(this);
    }

    public boolean hasChildren() {
        return !this.isLeaf();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void addChild(Node n) {
        this.insertChild(n, this.getChildCount());
    }

    public void insertChild(Node n, int pos) {
        int numChildren = this.getChildCount();
        Node[] newChild = new Node[numChildren + 1];
        int i = 0;
        while (i < pos) {
            newChild[i] = this.child[i];
            ++i;
        }
        newChild[pos] = n;
        int i2 = pos;
        while (i2 < numChildren) {
            newChild[i2 + 1] = this.child[i2];
            ++i2;
        }
        this.child = newChild;
        n.setParent(this);
    }

    public Node removeChild(int n) {
        int numChildren = this.getChildCount();
        if (n >= numChildren) {
            throw new IllegalArgumentException("Nonexistent child");
        }
        Node[] newChild = new Node[numChildren - 1];
        int i = 0;
        while (i < n) {
            newChild[i] = this.child[i];
            ++i;
        }
        int i2 = n;
        while (i2 < numChildren - 1) {
            newChild[i2] = this.child[i2 + 1];
            ++i2;
        }
        Node removed = this.child[n];
        removed.setParent(null);
        this.child = newChild;
        return removed;
    }

    public void lengths2HeightsContemp() {
        double largestHeight = 0.0;
        if (!this.isLeaf()) {
            int i = 0;
            while (i < this.getChildCount()) {
                NodeUtils.lengths2Heights(this.getChild(i));
                double newHeight = this.getChild(i).getNodeHeight() + this.getChild(i).getBranchLength();
                if (newHeight > largestHeight) {
                    largestHeight = newHeight;
                }
                ++i;
            }
        }
        this.setNodeHeight(largestHeight);
    }

    public final void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
    }

    public final Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public final Enumeration getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keys();
    }

    public final int getChildCount() {
        if (this.child == null) {
            return 0;
        }
        return this.child.length;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        NodeUtils.printNH(new PrintWriter(sw), this, true, false, 0, false);
        return sw.toString();
    }

    static {
        serialVersionUID = 3472432765038556717L;
    }
}

