/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Hashtable;
import pal.misc.Identifier;
import pal.misc.LabelMapping;
import pal.misc.Report;
import pal.misc.Units;
import pal.tree.AttributeNode;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.SimpleNode;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class SimpleTree
implements Tree,
Report,
Units,
Serializable {
    private Node root;
    private Node[] internalNode = null;
    private int numInternalNodes;
    private Node[] externalNode = null;
    private int numExternalNodes;
    private Hashtable[] attributes = null;
    private int units = 0;
    static final long serialVersionUID = -7330318631600898531L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.root);
        out.writeObject(this.attributes);
        out.writeInt(this.units);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.root = (Node)in.readObject();
        this.createNodeList();
        this.attributes = (Hashtable[])in.readObject();
        this.units = in.readInt();
    }

    public SimpleTree() {
        this.root = new SimpleNode();
        this.root.setIdentifier(new Identifier("ROOT"));
        this.root.setBranchLength(0.0);
        this.root.setBranchLengthSE(0.0);
    }

    public SimpleTree(Node r) {
        this.root = r;
        this.createNodeList();
    }

    public SimpleTree(Tree tree) {
        this.root = new SimpleNode(tree.getRoot());
        this.setUnits(tree.getUnits());
        this.createNodeList();
    }

    public SimpleTree(Tree tree, boolean keepIdentifiers) {
        this.root = new SimpleNode(tree.getRoot(), keepIdentifiers);
        this.setUnits(tree.getUnits());
        this.createNodeList();
    }

    public SimpleTree(Tree tree, LabelMapping lm) {
        this.root = new SimpleNode(tree.getRoot(), lm);
        this.setUnits(tree.getUnits());
        this.createNodeList();
    }

    public final int getUnits() {
        return this.units;
    }

    public final void setUnits(int units) {
        this.units = units;
    }

    public final int getExternalNodeCount() {
        if (this.externalNode == null) {
            this.createNodeList();
        }
        return this.numExternalNodes;
    }

    public final Node getExternalNode(int i) {
        if (this.externalNode == null) {
            this.createNodeList();
        }
        return this.externalNode[i];
    }

    public final int getInternalNodeCount() {
        if (this.internalNode == null) {
            this.createNodeList();
        }
        return this.numInternalNodes;
    }

    public final Node getInternalNode(int i) {
        if (this.internalNode == null) {
            this.createNodeList();
        }
        return this.internalNode[i];
    }

    public final Node getRoot() {
        return this.root;
    }

    public final void setRoot(Node r) {
        this.root = r;
        this.createNodeList();
    }

    public void createNodeList() {
        this.numInternalNodes = 0;
        this.numExternalNodes = 0;
        Node node = this.root;
        do {
            if ((node = NodeUtils.postorderSuccessor(node)).isLeaf()) {
                node.setNumber(this.numExternalNodes);
                ++this.numExternalNodes;
                continue;
            }
            node.setNumber(this.numInternalNodes);
            ++this.numInternalNodes;
        } while (node != this.root);
        this.internalNode = new Node[this.numInternalNodes];
        this.externalNode = new Node[this.numExternalNodes];
        node = this.root;
        do {
            if ((node = NodeUtils.postorderSuccessor(node)).isLeaf()) {
                this.externalNode[node.getNumber()] = node;
                continue;
            }
            this.internalNode[node.getNumber()] = node;
        } while (node != this.root);
        if (this.root.getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(this.root);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        NodeUtils.printNH(new PrintWriter(sw), this.getRoot(), true, false, 0, false);
        sw.write(";");
        return sw.toString();
    }

    public Node findNode(int num) {
        this.createNodeList();
        if (num <= this.numExternalNodes) {
            return this.externalNode[num - 1];
        }
        return this.internalNode[num - 1 - this.numExternalNodes];
    }

    private int getIndex(Node node) {
        if (node.isLeaf()) {
            return node.getNumber();
        }
        return this.getExternalNodeCount() + node.getNumber();
    }

    public void setAttribute(Node node, String name, Object value) {
        if (node instanceof AttributeNode) {
            ((AttributeNode)node).setAttribute(name, value);
        } else {
            int index = this.getIndex(node);
            if (this.attributes == null) {
                this.attributes = new Hashtable[this.getExternalNodeCount() + this.getInternalNodeCount()];
            }
            if (this.attributes[index] == null) {
                this.attributes[index] = new Hashtable();
            }
            this.attributes[index].put(name, value);
        }
    }

    public Object getAttribute(Node node, String name) {
        if (node instanceof AttributeNode) {
            return ((AttributeNode)node).getAttribute(name);
        }
        int index = this.getIndex(node);
        if (this.attributes == null || this.attributes[index] == null) {
            return null;
        }
        return this.attributes[index].get(name);
    }

    public void reroot(int num) {
        TreeUtils.reroot(this, this.findNode(num));
    }

    public void reroot(Node node) {
        TreeUtils.reroot(this, node);
    }

    public void report(PrintWriter out) {
        TreeUtils.report(this, out);
    }

    static {
        serialVersionUID = -7330318631600898531L;
    }
}

