/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.distance.DistanceMatrix;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;

public class UPGMATree
extends SimpleTree {
    private int numClusters;
    private Node newCluster;
    private int besti;
    private int abi;
    private int bestj;
    private int abj;
    private int[] alias;
    private double[][] distance;
    private double[] height;
    private int[] oc;

    public UPGMATree(DistanceMatrix m) {
        if (m.numSeqs < 2) {
            new IllegalArgumentException("LESS THAN 2 TAXA IN DISTANCE MATRIX");
        }
        if (!m.isSymmetric()) {
            new IllegalArgumentException("UNSYMMETRIC DISTANCE MATRIX");
        }
        this.init(m);
        while (true) {
            this.findNextPair();
            this.newBranchLengths();
            if (this.numClusters == 2) break;
            this.newCluster();
        }
        this.finish();
        this.createNodeList();
    }

    private double getDist(int a, int b) {
        return this.distance[this.alias[a]][this.alias[b]];
    }

    private void init(DistanceMatrix m) {
        this.numClusters = m.numSeqs;
        this.distance = new double[this.numClusters][this.numClusters];
        int i = 0;
        while (i < this.numClusters) {
            int j = 0;
            while (j < this.numClusters) {
                this.distance[i][j] = m.distance[i][j];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numClusters) {
            Node tmp = NodeFactory.createNode();
            tmp.setIdentifier(m.getIdentifier(i2));
            this.getRoot().addChild(tmp);
            ++i2;
        }
        this.alias = new int[this.numClusters];
        int i3 = 0;
        while (i3 < this.numClusters) {
            this.alias[i3] = i3;
            ++i3;
        }
        this.height = new double[this.numClusters];
        this.oc = new int[this.numClusters];
        int i4 = 0;
        while (i4 < this.numClusters) {
            this.height[i4] = 0.0;
            this.oc[i4] = 1;
            ++i4;
        }
    }

    private void finish() {
        this.distance = null;
    }

    private void findNextPair() {
        this.besti = 0;
        this.bestj = 1;
        double dmin = this.getDist(0, 1);
        int i = 0;
        while (i < this.numClusters - 1) {
            int j = i + 1;
            while (j < this.numClusters) {
                if (this.getDist(i, j) < dmin) {
                    dmin = this.getDist(i, j);
                    this.besti = i;
                    this.bestj = j;
                }
                ++j;
            }
            ++i;
        }
        this.abi = this.alias[this.besti];
        this.abj = this.alias[this.bestj];
    }

    private void newBranchLengths() {
        double dij = this.getDist(this.besti, this.bestj);
        this.getRoot().getChild(this.besti).setBranchLength(dij / 2.0 - this.height[this.abi]);
        this.getRoot().getChild(this.bestj).setBranchLength(dij / 2.0 - this.height[this.abj]);
    }

    private void newCluster() {
        int k = 0;
        while (k < this.numClusters) {
            if (k != this.besti && k != this.bestj) {
                int ak = this.alias[k];
                double d = this.updatedDistance(this.besti, this.bestj, k);
                this.distance[this.abi][ak] = d;
                this.distance[ak][this.abi] = d;
            }
            ++k;
        }
        this.distance[this.abi][this.abi] = 0.0;
        this.height[this.abi] = this.getDist(this.besti, this.bestj) / 2.0;
        int n = this.abi;
        this.oc[n] = this.oc[n] + this.oc[this.abj];
        NodeUtils.joinChilds(this.getRoot(), this.besti, this.bestj);
        int i = this.bestj;
        while (i < this.numClusters - 1) {
            this.alias[i] = this.alias[i + 1];
            ++i;
        }
        --this.numClusters;
    }

    private double updatedDistance(int i, int j, int k) {
        int ai = this.alias[i];
        int aj = this.alias[j];
        double ocsum = this.oc[ai] + this.oc[aj];
        return (double)this.oc[ai] / ocsum * this.getDist(k, i) + (double)this.oc[aj] / ocsum * this.getDist(k, j);
    }
}

