/*
 * Decompiled with CFR 0.152.
 */
package pal.xml;

import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import pal.alignment.Alignment;
import pal.alignment.SimpleAlignment;
import pal.coalescent.ConstExpGrowth;
import pal.coalescent.ConstantPopulation;
import pal.coalescent.DemographicModel;
import pal.coalescent.ExponentialGrowth;
import pal.datatype.AminoAcids;
import pal.datatype.Codons;
import pal.datatype.DataType;
import pal.datatype.DataTypeUtils;
import pal.datatype.Nucleotides;
import pal.datatype.TwoStates;
import pal.mep.ConstantMutationRate;
import pal.mep.MutationRateModel;
import pal.mep.SteppedMutationRate;
import pal.misc.Attribute;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;
import pal.misc.TimeOrderCharacterData;
import pal.substmodel.F81;
import pal.substmodel.F84;
import pal.substmodel.GTR;
import pal.substmodel.HKY;
import pal.substmodel.NucleotideModel;
import pal.substmodel.RateMatrix;
import pal.tree.AttributeNode;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.util.XMLConstants;
import pal.xml.XmlParseException;

public class ElementParser
implements XMLConstants {
    public static Element getFirstByName(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagName(name);
        if (nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public static Alignment parseAlignmentElement(Element e) throws XmlParseException {
        SimpleAlignment alignment = null;
        DataType dataType = Nucleotides.DEFAULT_INSTANCE;
        String gaps = "-";
        ElementParser.validateTagName(e, "alignment");
        if (ElementParser.hasAttribute(e, "missing")) {
            gaps = e.getAttribute("missing");
        }
        if (ElementParser.hasAttribute(e, "datatypeid")) {
            String dataTypeId = e.getAttribute("datatypeid");
            dataType = DataTypeUtils.getInstance(Integer.parseInt(dataTypeId));
        } else if (ElementParser.hasAttribute(e, "datatype")) {
            String dataTypeStr = e.getAttribute("datatype");
            if (dataTypeStr.equals("nucleotide")) {
                dataType = Nucleotides.DEFAULT_INSTANCE;
            } else if (dataTypeStr.equals("amino acid")) {
                dataType = AminoAcids.DEFAULT_INSTANCE;
            } else if (dataTypeStr.equals("codon")) {
                dataType = new Codons();
            } else if (dataTypeStr.equals("binary")) {
                dataType = new TwoStates();
            }
        }
        NodeList nodes = e.getElementsByTagName("sequence");
        String[] sequences = new String[nodes.getLength()];
        String[] names = new String[nodes.getLength()];
        int i = 0;
        while (i < sequences.length) {
            Element sequence = (Element)nodes.item(i);
            names[i] = ElementParser.getNameAttr(sequence);
            sequences[i] = "";
            NodeList seqs = sequence.getChildNodes();
            int j = 0;
            while (j < seqs.getLength()) {
                if (seqs.item(j) instanceof Text) {
                    int n = i;
                    sequences[n] = sequences[n] + ((Text)seqs.item(j)).getNodeValue();
                }
                ++j;
            }
            ++i;
        }
        alignment = new SimpleAlignment((IdGroup)new SimpleIdGroup(names), sequences, gaps);
        alignment.setDataType(dataType);
        return alignment;
    }

    public static Attribute parseAttributeElement(Element e) throws XmlParseException {
        String name = null;
        String value = null;
        String type = null;
        ElementParser.validateTagName(e, "att");
        if (!ElementParser.hasAttribute(e, "name")) {
            throw new XmlParseException("att tags require a name attribute!");
        }
        name = e.getAttribute("name");
        if (!ElementParser.hasAttribute(e, "value")) {
            throw new XmlParseException("att tags require a value attribute!");
        }
        value = e.getAttribute("value");
        if (ElementParser.hasAttribute(e, "type")) {
            type = e.getAttribute("type");
        }
        return new Attribute(name, value, type);
    }

    public static DemographicModel parseDemographicModel(Element e) throws XmlParseException {
        ConstantPopulation model = null;
        int units = 1;
        double growthRate = 0.0;
        double populationSize = 1.0;
        double ancestral = 0.0;
        int parameterization = 0;
        ElementParser.validateTagName(e, "demographicmodel");
        units = ElementParser.getUnitsAttr(e);
        NodeList nodes = e.getElementsByTagName("parameter");
        int i = 0;
        while (i < nodes.getLength()) {
            Element param = (Element)nodes.item(i);
            String name = ElementParser.getNameAttr(param);
            if (name.equals("current population size")) {
                populationSize = ElementParser.getDoubleValue(param);
            } else if (name.equals("growth rate")) {
                growthRate = ElementParser.getDoubleValue(param);
            } else if (name.equals("alpha")) {
                ancestral = ElementParser.getDoubleValue(param);
            } else if (name.equals("ancestral population size")) {
                ancestral = ElementParser.getDoubleValue(param);
                parameterization = 1;
            }
            ++i;
        }
        String type = e.getAttribute("type");
        if (type.equals("constant")) {
            model = new ConstantPopulation(populationSize, units);
        } else if (type.equals("exponential")) {
            model = new ExponentialGrowth(populationSize, growthRate, units);
        } else if (type.toLowerCase().equals("constexp")) {
            model = new ConstExpGrowth(populationSize, growthRate, ancestral, units, parameterization);
        }
        return model;
    }

    public static Node parseEdgeNodeElement(Element e) throws XmlParseException {
        Node node = null;
        ElementParser.validateTagName(e, "edge");
        node = NodeFactory.createNode();
        if (ElementParser.hasAttribute(e, "length")) {
            node.setBranchLength(Double.parseDouble(e.getAttribute("length")));
        }
        NodeList nodes = e.getChildNodes();
        int nodeCount = 0;
        int i = 0;
        while (i < nodes.getLength()) {
            Element element;
            if (nodes.item(i) instanceof Element && (element = (Element)nodes.item(i)).getTagName().equals("node")) {
                if (nodeCount > 0) {
                    throw new RuntimeException("Each edge should contain only 1 node!!");
                }
                ElementParser.parseNodeElement((Element)nodes.item(0), node);
                ++nodeCount;
            }
            ++i;
        }
        return node;
    }

    public static final double[] parseFrequencies(Element element) throws XmlParseException {
        Vector<Double> freqs = new Vector<Double>();
        ElementParser.validateTagName(element, "frequencies");
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            org.w3c.dom.Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                String text = node.getNodeValue();
                StringTokenizer tokens = new StringTokenizer(text);
                while (tokens.hasMoreElements()) {
                    String token = (String)tokens.nextElement();
                    freqs.addElement(new Double(token));
                }
            }
            ++i;
        }
        double[] frequencies = new double[freqs.size()];
        int i2 = 0;
        while (i2 < frequencies.length) {
            frequencies[i2] = (Double)freqs.elementAt(i2);
            ++i2;
        }
        return frequencies;
    }

    public static MutationRateModel parseMutationRateModel(Element e) throws XmlParseException {
        MutationRateModel model = null;
        int units = 1;
        double mutationRate = 1.0;
        double stepTime = Double.MAX_VALUE;
        double ancestralRate = 0.0;
        ElementParser.validateTagName(e, "mutationratemodel");
        units = ElementParser.getUnitsAttr(e);
        if (units == 0) {
            throw new RuntimeException("mutations rate can't be in mutation units!");
        }
        NodeList nodes = e.getElementsByTagName("parameter");
        int i = 0;
        while (i < nodes.getLength()) {
            Element param = (Element)nodes.item(i);
            String name = ElementParser.getNameAttr(param);
            if (name.equals("current mutation rate")) {
                mutationRate = ElementParser.getDoubleValue(param);
            } else if (name.equals("step time")) {
                stepTime = ElementParser.getDoubleValue(param);
            } else if (name.equals("ancestral mutation rate")) {
                ancestralRate = ElementParser.getDoubleValue(param);
            }
            ++i;
        }
        String type = e.getAttribute("type");
        if (type.equals("constant")) {
            model = new ConstantMutationRate(mutationRate, units);
        } else if (type.equals("stepped")) {
            double[] rates = new double[]{mutationRate, ancestralRate};
            double[] steps = new double[]{stepTime};
            model = new SteppedMutationRate(rates, steps, units);
        }
        return model;
    }

    public static Node parseNodeElement(Element e) throws XmlParseException {
        Node node = NodeFactory.createNode();
        ElementParser.parseNodeElement(e, node);
        return node;
    }

    public static RateMatrix parseRateMatrix(Element e) throws XmlParseException {
        return ElementParser.parseRateMatrix(e, null);
    }

    protected static RateMatrix parseRateMatrix(Element e, Alignment a) throws XmlParseException {
        NucleotideModel rateMatrix = null;
        double[] frequencies = null;
        ElementParser.validateTagName(e, "ratematrix");
        String type = e.getAttribute("model");
        Element freqElement = ElementParser.getFirstByName(e, "frequencies");
        if (type.equals("JC")) {
            if (freqElement != null) {
                throw new XmlParseException("Frequency sub-element not allowed in JC model!");
            }
            return new F81(new double[]{0.25, 0.25, 0.25, 0.25});
        }
        if (freqElement != null) {
            frequencies = ElementParser.parseFrequencies(freqElement);
        } else if (a != null) {
            frequencies = a.getFrequency();
        } else {
            throw new XmlParseException("Must have either frequency element or an associated alignment!");
        }
        if (type.equals("F81")) {
            rateMatrix = new F81(frequencies);
        } else if (type.equals("F84")) {
            rateMatrix = new F84(1.0, frequencies);
        } else if (type.equals("HKY")) {
            rateMatrix = new HKY(1.0, frequencies);
        } else if (type.equals("GTR")) {
            rateMatrix = new GTR(1.0, 1.0, 1.0, 1.0, 1.0, frequencies);
        } else {
            throw new XmlParseException("rate matrix model '" + type + "' unexpected!");
        }
        NodeList nodes = e.getElementsByTagName("parameter");
        int i = 0;
        while (i < nodes.getLength()) {
            Element param = (Element)nodes.item(i);
            String name = ElementParser.getNameAttr(param);
            if (name.equals("kappa")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 0);
            } else if (name.equals("transition/transversion ratio")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 0);
            } else if (name.equals("A-C")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 0);
            } else if (name.equals("A-G")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 1);
            } else if (name.equals("A-T")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 2);
            } else if (name.equals("C-G")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 3);
            } else if (name.equals("C-T")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 4);
            } else if (name.equals("G-T")) {
                rateMatrix.setParameter(ElementParser.getDoubleValue(param), 5);
            } else {
                throw new XmlParseException("rate matrix parameter '" + name + "' unexpected!");
            }
            ++i;
        }
        return rateMatrix;
    }

    public static TimeOrderCharacterData parseTimeDataElement(Element e) throws XmlParseException {
        TimeOrderCharacterData tocd = null;
        int units = 1;
        ElementParser.validateTagName(e, "timedata");
        units = ElementParser.getUnitsAttr(e);
        NodeList nodes = e.getElementsByTagName("time");
        Vector<String> names = new Vector<String>();
        Vector<Double> times = new Vector<Double>();
        int i = 0;
        while (i < nodes.getLength()) {
            Element timeElement = (Element)nodes.item(i);
            Double time = new Double(timeElement.getAttribute("value"));
            NodeList children = timeElement.getChildNodes();
            if (children.item(0) instanceof Text) {
                StringTokenizer tokens = new StringTokenizer(children.item(0).getNodeValue());
                while (tokens.hasMoreTokens()) {
                    names.addElement(tokens.nextToken());
                    times.addElement(time);
                }
            } else {
                throw new XmlParseException("Non-text node found in time element!");
            }
            ++i;
        }
        String[] nameArray = new String[names.size()];
        double[] timeArray = new double[names.size()];
        int i2 = 0;
        while (i2 < nameArray.length) {
            nameArray[i2] = (String)names.elementAt(i2);
            timeArray[i2] = (Double)times.elementAt(i2);
            ++i2;
        }
        tocd = new TimeOrderCharacterData(new SimpleIdGroup(nameArray), units);
        tocd.setTimes(timeArray, units);
        return tocd;
    }

    public static Tree parseTreeElement(Element e) throws XmlParseException {
        SimpleTree tree = null;
        int units = 1;
        ElementParser.validateTagName(e, "tree");
        units = ElementParser.getUnitsAttr(e);
        NodeList nodes = e.getElementsByTagName("node");
        Node root = ElementParser.parseNodeElement((Element)nodes.item(0));
        if (root.getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(root);
        } else {
            NodeUtils.heights2Lengths(root);
        }
        tree = new SimpleTree(root);
        tree.setUnits(units);
        return tree;
    }

    public static void validateTagName(Element e, String name) throws XmlParseException {
        if (!e.getTagName().equals(name)) {
            throw new XmlParseException("Wrong tag name! Expected " + name + ", found " + e.getTagName() + ".");
        }
    }

    protected static double getDoubleValue(Element e) {
        return Double.parseDouble(e.getAttribute("value"));
    }

    protected static String getNameAttr(Element e) {
        return e.getAttribute("name");
    }

    protected static int getUnitsAttr(Element e) {
        int units = 1;
        if (ElementParser.hasAttribute(e, "units")) {
            String unitsAttr = e.getAttribute("units");
            if (unitsAttr.equals("years")) {
                units = 4;
            } else if (unitsAttr.equals("months")) {
                units = 3;
            } else if (unitsAttr.equals("days")) {
                units = 2;
            } else if (unitsAttr.equals("mutations")) {
                units = 0;
            }
        }
        return units;
    }

    protected static final boolean hasAttribute(Element e, String name) {
        String attr = e.getAttribute(name);
        return attr != null && !attr.equals("");
    }

    private static void parseNodeElement(Element e, Node node) throws XmlParseException {
        ElementParser.validateTagName(e, "node");
        if (ElementParser.hasAttribute(e, "height")) {
            node.setNodeHeight(Double.parseDouble(e.getAttribute("height")));
        }
        if (ElementParser.hasAttribute(e, "name")) {
            node.setIdentifier(new Identifier(e.getAttribute("name")));
        }
        NodeList nodes = e.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i) instanceof Element) {
                Element child = (Element)nodes.item(i);
                if (child.getTagName().equals("node")) {
                    node.addChild(ElementParser.parseNodeElement((Element)nodes.item(i)));
                } else if (child.getTagName().equals("edge")) {
                    node.addChild(ElementParser.parseEdgeNodeElement((Element)nodes.item(i)));
                } else if (child.getTagName().equals("att") && node instanceof AttributeNode) {
                    Attribute a = ElementParser.parseAttributeElement(child);
                    ((AttributeNode)node).setAttribute(a.getName(), a.getValue());
                }
            }
            ++i;
        }
    }
}

