import sys
import os
import numpy as np
import utils

# appending neurips_experiments to PATH so we can directly execute plot_experiment
SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))
sys.path.append(os.path.dirname(SCRIPT_DIR))


def append_info(current, info, method):
    if(info[0] == 'Acc {} is'.format(method)):
        current[method].append([float(info[1]), float(info[2]), float(info[3]), float(info[4]), float(info[5]), float(info[6]), float(info[7]), float(info[8]), float(info[9]), float(info[10]), float(info[11]), float(info[12]), float(info[13]), float(info[14])])


def save_results(current, filename, args, r, n, t, d):      
    with open('results/AVG_{}.csv'.format(filename), 'a') as f:
        # Log results
        avg = {}
        std = {}

        f.write("Total executions were {}\n".format(r))
        f.write('samples = {}, timesteps = {}, nodes = {}, edges = {}\n'.format(n, t, d, args.edges * d + 2 * d * args.number_of_lags))

        
        for method in args.methods:
            if len(current[method]) > 1:
                avg[method] = np.mean(current[method], axis=0)
                std[method] = np.std(current[method], axis=0)
                
                f.write("Acc {} is, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}\n".format(method, avg[method][0], avg[method][1], avg[method][2], avg[method][3], avg[method][4], avg[method][5], avg[method][6], avg[method][7], avg[method][8], avg[method][9], avg[method][10], avg[method][11], avg[method][12], avg[method][13]))
                f.write("Std {} is, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}, {:.3f}\n".format(method, std[method][0], std[method][1], std[method][2], std[method][3], std[method][4], std[method][5], std[method][6], std[method][7], std[method][8], std[method][9], std[method][10], std[method][11], std[method][12], std[method][13]))
    f.close()


if __name__ == '__main__':
    parser, args = utils.get_args()

    # naming the output files according to the experimental settings
    filename, label = utils.get_filename(parser, args)
    parser, args = utils.get_args()

    current = {}
    for key in args.methods:
        current[key] = []

    n, t, d = 0, 0, 0
    with open('results/{}.csv'.format(filename), 'r') as f:
            print("Reading from file results/{}".format(filename))
            r=0
            for line in f:
                info = line.split(',')
                if info[0][:7] == 'samples':
                    if current != {}:
                        save_results(current, filename, args, r / (len(args.methods)), n, t, d)

                    # new values
                    n = int(info[0].split("=")[-1])
                    t = int(info[1].split("=")[-1])
                    d = int(info[2].split("=")[-1])
                    r = 0
                    current = {}
                    for key in args.methods:
                        current[key] = []

                elif info[0][:3] == "Acc":
                    for method in args.methods:
                        append_info(current, info, method)
                        r += 1
            if current != {}:
                save_results(current, filename, args, r / (len(args.methods)), n, t, d)