#!/usr/bin/env Rscript

args = commandArgs(trailingOnly=TRUE)
name_dataframe = args[1]
data <- read.csv(file = name_dataframe)
data$time_index <- NULL
name_alpha = args[2]
alpha <- scan(name_alpha, what=double())
name_n_lags = args[3]
n_lags <- scan(name_n_lags, what=double())

start_up <- function() {
    library(gam)
    library(kernlab)
    source("./experiments/methods/TiMINO/timino_causality.R")
    source("./experiments/methods/TiMINO/util/hammingDistance.R")
    source("./experiments/methods/TiMINO/util/indtestAll.R")
    source("./experiments/methods/TiMINO/util/indtestHsic.R")
    source("./experiments/methods/TiMINO/util/indtestPcor.R")
    source("./experiments/methods/TiMINO/util/TSindtest.R")
    source("./experiments/methods/TiMINO/util/fitting_ts.R")
}
start_up()

result <- timino_dag(data, alpha = alpha, max_lag = n_lags, model = traints_linear, indtest = indtestts_crosscov, output = TRUE)

result[is.na(result)] <- 0


write.table(result, "./experiments/methods/TiMINO/data_timino/result.csv", col.names = colnames(data), row.names = colnames(data), sep = ",")

