#!/usr/bin/env Rscript

args = commandArgs(trailingOnly=TRUE)
name_dataframe = args[1]
data <- read.csv(file = name_dataframe)
name_alpha = args[2]
alpha <- scan(name_alpha, what=double())
name_n_lags = args[3]
n_lags <- scan(name_n_lags, what=double())
name_sig = args[4]
sig <- scan(name_sig, what=double())

print("#######################")

start_up <- function() {
  source('./experiments/methods/tsFCI/dconnected.R')
  source('./experiments/methods/tsFCI/genData.R')
  source('./experiments/methods/tsFCI/main_tetrad_fci.R')
  source('./experiments/methods/tsFCI/plot_timeseries.R')
  source('./experiments/methods/tsFCI/Plotting_Commands_Barplots.R')
  source('./experiments/methods/tsFCI/plot_ts_pag.R')
  source('./experiments/methods/tsFCI/realData_tsfci.R')
  source('./experiments/methods/tsFCI/scores.R')
  source('./experiments/methods/tsFCI/Simulation_Commands.R')
  source('./experiments/methods/tsFCI/Simulations_data_cont.R')
  source('./experiments/methods/tsFCI/Simulations_data_disc.R')
  source('./experiments/methods/tsFCI/Simulations_graph.R')
  source('./experiments/methods/tsFCI/Tetrad_R_interact.R')
  source('./experiments/methods/tsFCI/ts_functions.R')
}
start_up()
# sig is the significance level which we set to 0.01 for the p-values
result <- realData_tsfci(data=data, sig=sig, nrep=n_lags, inclIE=FALSE, alg="tscfci", datatype="continuous", makeplot=FALSE, pathName = './experiments/methods/tsFCI/')

write.table(result, "./experiments/methods/tsFCI/data_tsfci/result.csv", sep = ",")


# C:/"Program Files"/R/R-4.2.1/bin/Rscript ./experiments/methods/tsFCI/tsfci.R ./experiments/methods/tsFCI/data_tsfci/data.csv ./experiments/methods/tsFCI/data_tsfci/omega.txt ./experiments/methods/tsFCI/data_tsfci/nlags.txt


