We have a file containing 1000 merger trees from cosmological N-body simulations. The file is located in /mnt/home/fanonymous/public_www/Pablo_Bermejo/Pablo_merger_trees2.pt

The data is stored in PyTorch Geometric format, and can be read as:

```python
import torch
f_tree = '/mnt/home/fanonymous/public_www/Pablo_Bermejo/Pablo_merger_trees2.pt'
trainset = torch.load(f_tree, weights_only=False)
```

trainset is now a collection of 1000 PyTorch Geometric graphs. For instance, trainset[0] represents the first merger tree and contains the data in this format:
Data(x=[382, 4], edge_index=[2, 381], edge_attr=[381, 1], y=[1, 2], num_nodes=382, lh_id=100, mask_main=[93], node_halo_id=[382, 1])

x represents the node features. y is the value of the cosmological parameters, Omega_m and sigma_8. The node features are mass, concentration, vmax, scale factor. The first property is log10(mass), the second is log10(concentration), the third one is log10(Vmax), and the fourth one is the scale factor.

The scale factor ranges from 0 (beginning of the universe) to 1 (current time). The mass goes from 10 to 15. Each node represents a dark matter halo and is characterized by the four values mentioned above: halo mass, halo concentration, halo Vmax (maximum circular velocity), and scale factor. You may want to normalize each feature to have mean 0. Omega_m ranges from 0.1 to 0.5, while sigma_8 goes from 0.6 to 1.0. For each simulation, i.e. a given value of the cosmological parameters, there are 25 different merger trees chosen randomly.

Please come up with an idea to explore this data using methods from Quantum Tensor Trains. Note that PyTorch and PyTorch Geometric are already installed. The system has 16 cpus and 1 gpu. Please make some plots to illustrate your findings.

Do you use external libraries for tensor trains