**IDEA:** QITT-Enhanced Multi-Scale Substructure Analysis with Learned Topological Embeddings for Cosmological Parameter Estimation

**Description:**

This idea leverages Quantum-Inspired Tensor Trains (QITT) on multi-scale substructure features, incorporating learned topological embeddings, for enhanced cosmological parameter estimation from dark matter halo merger trees. It focuses on physically motivated features alongside a topological representation learned via graph neural networks.

1.  **Multi-Scale Substructure Identification:** Identify substructures at different scales based on both mass accretion rate and significant changes in halo properties (shape, spin). Use adaptive thresholds for mass accretion rates, determined by percentiles within each tree.

2.  **Feature Extraction:** Extract physical features (mass ratio, merger time, concentration, Vmax difference) and learn topological embeddings:
    *   Apply a Graph Neural Network (GNN, e.g., GraphSAGE or GAT) to each substructure graph to generate a low-dimensional topological embedding. The GNN will be trained separately on a large number of generated graphs to capture relevant topological features.

3.  **Tensor Construction:** Concatenate physical features and topological embedding vectors for each substructure. Organize these into a tensor, padding with learned embeddings (instead of zeros) from a separate "padding" graph, to maintain consistent dimensionality. Justify the tensor shape based on the average number of identified substructures.

4.  **QITT Decomposition:** Apply QITT decomposition (using the TensorLy library) with rank selection via cross-validation. Employ tensor-specific regularization techniques like Tucker regularization during QITT training.

5.  **Regression:** Train regression models (including Random Forest, Gradient Boosting, and Linear Regression) using concatenated and flattened QITT cores as input. Perform hyperparameter tuning with cross-validation, justifying model choices based on expected data characteristics.

6.  **Visualization:** Visualize substructure graphs corresponding to the largest singular values to understand the relevant topologies. Examine the learned topological embeddings.

7.  **Comparison:** Compare against baselines: aggregate graph-level features, raw substructure features, and a model using graphlet counts. Employ appropriate feature engineering for baselines. Use RMSE and R-squared, and perform t-tests for statistical significance.