# -*- coding: utf-8 -*-
"""
Created on Sat Nov 11 13:43:29 2023

@author: xiato
"""

import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import beta
plt.figure(dpi=500, figsize=(4,2))

# Generate values from the beta distribution
x = np.linspace(0, 1, 1000)



plt.text(0.39,4.8, 'Acc=57.75%')
plt.text(0.39,3.5, 'Acc=58.19%')
plt.text(0.39,2.5, 'Acc=58.26%')
plt.text(0.39,1.5, 'Acc=57.73%')
plt.text(0.38,0.83, 'Acc=58.02%')



a = 20
y = beta.pdf(x, a, a)
plt.plot(x, y, '-', lw=2, label=r'$a=20$')


a = 10
y = beta.pdf(x, a, a)
plt.plot(x, y, '-', lw=2, label=r'$a=10$')


a = 5
y = beta.pdf(x, a, a)
plt.plot(x, y, '-', lw=2, label=r'$a=5$')


a = 2
y = beta.pdf(x, a, a)
plt.plot(x, y, '-', lw=2, label=r'$a=2$')



a = 1.5
y = beta.pdf(x, a, a)
plt.plot(x, y, '-', lw=2, label=r'$\alpha=1.5$')




# Add labels and title
plt.xlabel(r'$\lambda$', fontsize=12)
plt.ylabel('PDF', size=12)
plt.legend(fontsize=8)

# Show the plot
plt.show()