# -*- coding: utf-8 -*-
"""
Created on Thu Nov 16 19:43:47 2023

@author: xiatong
"""

import numpy as np
import matplotlib.pyplot as plt


### For audio
x = [0, 5, 10, 20,50, 100]
y1 = [43.7, 48.7, 51.56, 53.0, 55.2, 58.9]
y2 = [43.7, 56.10, 57.73, 58.59, 60.0, 62]

# Create the first plot with the left y-axis
plt.subplots(dpi=800, figsize=(3,1.6))
plt.plot(x, y1, '-s',label = 'FedMix')
plt.plot(x, y2, '-s',label = 'FLea')
plt.xticks(x)
plt.yticks([42, 46,50,54,58,62])
plt.ylabel('Accuracy %')
plt.xlabel(r'$\alpha$ %')
plt.title('UrbanSound8K (Quantity(3))')
plt.legend()



### For audio
x = [0.0,1,2,4,6]
y1 = [59, 61.2, 61, 60,57]
y2 = [56.5, 57.7, 57.9, 57.2, 56.7]

# Create the first plot with the left y-axis
plt.subplots(dpi=500, figsize=(1.8,1.6))
plt.plot(x, y1, '-s',label = r'$\lambda_2=0$')
plt.plot(x, y2, '-s',label = r'$\lambda_2=3$')
plt.xticks(x)
plt.yticks([56,57,58,59,60,61])
plt.ylabel('Accuracy %')
plt.xlabel(r'$\lambda_1$')
plt.legend()

### For audio
x = [0, 1, 2, 3, 4, 5, 6,7]
y1 = [0.99,0.75,0.745,0.718,0.703,0.673,0.593, 0.563] 
y1 = [1-y for y in y1]
y2 = [0.612,0.591,0.582,0.577,0.569,0.548,0.505, 0.501]
y2 = [100*y for y in y2]

# Create the first plot with the left y-axis
fig, ax1 = plt.subplots(dpi=500, figsize=(2.3,2))

ax1.set_xlabel(r'$\lambda_2$', fontsize=14)
ax1.set_ylabel(r'$1-\bar{c}$', color='tab:blue', fontsize=14)
ax1.plot(x, y1, '-s', color='tab:blue')
ax1.tick_params(axis='y', labelcolor='tab:blue', labelsize=12)


custom_xticklabels = ['0', '1', '2', '3', '4', '6', '8', '10']
ax1.set_xticks(x)
ax1.set_xticklabels(custom_xticklabels, fontsize=12)  # Adjust fontsize, rotation, and ha as needed


# Create the second plot with the right y-axis
ax2 = ax1.twinx()
ax2.set_ylabel('Accuracy %', color='tab:red', fontsize=14)
ax2.plot(x, y2, '-s', color='tab:red')
ax2.tick_params(axis='y', labelcolor='tab:red', labelsize=12)
ax2.set_yticks([60,55,50])

plt.figure(dpi=500, figsize=(2.3,2))
x = [0, 1, 2, 3, 4, 5]
y1 = [0.85,0.73,0.71,0.71,0.703,0.68]