import torch
import torch.nn.functional as F
import time

def compute_alpha(beta, t):
    beta = torch.cat([torch.zeros(1).to(beta.device), beta], dim=0)
    a = (1 - beta).cumprod(dim=0).index_select(0, t + 1).view(-1, 1, 1, 1)
    return a


def generalized_steps(x, seq, model, b, **kwargs):
    with torch.no_grad():
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        x0_preds = []
        xs = [x]
        t_0 = time.time()
        for i, j in zip(reversed(seq), reversed(seq_next)):
            t = (torch.ones(n) * i).to(x.device)
            next_t = (torch.ones(n) * j).to(x.device)
            at = compute_alpha(b, t.long())
            at_next = compute_alpha(b, next_t.long())
            xt = xs[-1].to('cuda')
            et = model(xt, t)
            x0_t = (xt - et * (1 - at).sqrt()) / at.sqrt()
            x0_preds.append(x0_t.to('cpu'))
            c1 = (
                kwargs.get("eta", 0) * ((1 - at / at_next) * (1 - at_next) / (1 - at)).sqrt()
            )
            c2 = ((1 - at_next) - c1 ** 2).sqrt()
            xt_next = at_next.sqrt() * x0_t + c1 * torch.randn_like(x) + c2 * et
            xs.append(xt_next.to('cpu'))
        t_1 = time.time()
        print(t_1-t_0)

    return xs, x0_preds

def generalized_private_steps(x, seq, model, classifier, scale, tolerance, b, **kwargs):
    with torch.no_grad():
        print('the scale is:', scale)
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        x0_preds = []
        xs = [x]
        t_0 = time.time()
        for i, j in zip(reversed(seq), reversed(seq_next)):
            t = (torch.ones(n) * i).to(x.device)
            next_t = (torch.ones(n) * j).to(x.device)
            at = compute_alpha(b, t.long())
            at_next = compute_alpha(b, next_t.long())
            xt = xs[-1].to('cuda')
            et = model(xt, t)
            EPSILON = 0.0001
            #print(i)
            with torch.enable_grad():
                x_t = xt.detach().requires_grad_(True)
                probs = torch.sigmoid(classifier(x_t, t))
                high_prob_of_0= (probs<tolerance).int()
                high_prob_of_1 = (probs>1-tolerance).int()

                total_0 = high_prob_of_0.sum()
                total_1 = high_prob_of_1.sum()
                #when probability of category 0 is high
                #take a negative gradient wrt probability of category 0
                grad_0 = 0
                grad_1 = 0
                if total_1 != 0:
                    grad_0 = (1-at).sqrt()*torch.autograd.grad(torch.log(torch.ones_like(probs)-probs + EPSILON), x_t, torch.ones_like(probs), retain_graph = True)[0]*scale
                #when probability of category 1 is high
                #take a negative gradient in the direction that the category is 1
                if total_0 != 0:
                    grad_1 = (1-at).sqrt()*torch.autograd.grad(torch.log(probs + EPSILON), x_t, torch.ones_like(probs))[0]*scale
            #get indices of data points that the classifier is more certain about:
            high_prob_of_0= (probs<tolerance).int()
            high_prob_of_1 = (probs>1-tolerance).int()
            #print(high_prob_of_0.sum(), high_prob_of_1.sum())
            #if ind_low_prob.sum() !=0 or ind_high_prob !=0:
            #print("past threshold:", sum(high_prob_of_0), sum(high_prob_of_1))
            #print("norm of epsilon_t:", torch.norm(et))
            
            
            
            
            correction_factor_0 = high_prob_of_0.unsqueeze(-1).unsqueeze(-1)*grad_1
            correction_factor_1 = high_prob_of_1.unsqueeze(-1).unsqueeze(-1)*grad_0
            #print("grad norms:", torch.norm(correction_factor_0), torch.norm(correction_factor_1))
            correction_factor = correction_factor_0 + correction_factor_1
            et = et-torch.nan_to_num(correction_factor, 0) #hard coded for now


            x0_t = (xt - et * (1 - at).sqrt()) / at.sqrt()
            x0_preds.append(x0_t.to('cpu'))
            c1 = (
                kwargs.get("eta", 0) * ((1 - at / at_next) * (1 - at_next) / (1 - at)).sqrt()
            )
            c2 = ((1 - at_next) - c1 ** 2).sqrt()
            xt_next = at_next.sqrt() * x0_t + c1 * torch.randn_like(x) + c2 * et
            xs.append(xt_next.to('cpu'))
        t_1 = time.time()
    return xs, x0_preds


def ddpm_steps(x, seq, model, b, **kwargs):
    with torch.no_grad():
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        xs = [x]
        x0_preds = []
        betas = b
        for i, j in zip(reversed(seq), reversed(seq_next)):
            t = (torch.ones(n) * i).to(x.device)
            next_t = (torch.ones(n) * j).to(x.device)
            at = compute_alpha(betas, t.long())
            atm1 = compute_alpha(betas, next_t.long())
            beta_t = 1 - at / atm1
            x = xs[-1].to('cuda')

            output = model(x, t.float())
            e = output

            x0_from_e = (1.0 / at).sqrt() * x - (1.0 / at - 1).sqrt() * e
            x0_from_e = torch.clamp(x0_from_e, -1, 1)
            x0_preds.append(x0_from_e.to('cpu'))
            mean_eps = (
                (atm1.sqrt() * beta_t) * x0_from_e + ((1 - beta_t).sqrt() * (1 - atm1)) * x
            ) / (1.0 - at)

            mean = mean_eps
            noise = torch.randn_like(x)
            mask = 1 - (t == 0).float()
            mask = mask.view(-1, 1, 1, 1)
            logvar = beta_t.log()
            sample = mean + mask * torch.exp(0.5 * logvar) * noise
            xs.append(sample.to('cpu'))
    return xs, x0_preds
