import numpy as np
import torch

def random(ratio_zero=0.5):
    def mask(dim):
        mask = np.zeros(dim)
        size = np.clip(int(dim * ratio_zero), 1, dim - 1)
        mask[np.random.choice(np.arange(dim), size, replace=False)] = 1
        return torch.Tensor(mask)
    return mask

def ordered(ratio_zero=0.5, right=False):
    def mask(dim):
        mask = np.ones(dim)
        size = np.clip(int(dim * ratio_zero), 1, dim - 1)
        mask[:size] = 0
        if right:
            mask = 1 - mask
        return torch.Tensor(mask)
    return mask

def parity(even_zero=False):
    def mask(dim):
        mask = np.zeros(dim)
        mask[::2] = 1
        if even_zero:
            mask = 1 - mask
        return torch.Tensor(mask)
    return mask
