# Code  for ICLR 2025 submission: Guaranteed Neural PDE Boundary Control with Neural Barrier Function

Our code will be released and available to the public once our work is accepted. This version is not very clean but can fully reproduce all of our experimental results. Here is a brief instruction to run the code. 

## Preparation
The code is based on [Julia](https://julialang.org/) and Python. It is tested with Julia v1.9.4. Check [here](https://julialang.org/downloads/oldreleases/) to install Julia environment. Install `NeuralOperators.jl` from [here](https://docs.sciml.ai/NeuralOperators/stable/#Installation). For Python part, the code is based on `PDEControlGym`, which can be installed based on [doc](https://pdecontrolgym.readthedocs.io/en/latest/guide/install.html).

## Data collection
Train the PPO and SAC models for each environment following `./PDEControlGym/README.md` of `PDEControlGym`.
To collect data for hyperbolic environment, see Jupyter file `./PDEControlGym/examples/transportPDE/HyperbolicPDEExample.ipynb` for details. To collect data for parabolic environment, see Jupyter file `./PDEControlGym/examples/reactionDiffusionPDE/ParabolicPDEExample.ipynb` for details. To collect data for Navier-Stokes environment, see Jupyter file `./PDEControlGym/examples/NavierStokes/NS2Dtest.ipynb` for details.

## Model training 
Under hyperbolic equation, see `./pde_safe_control/train_hyper_all_pf.jl` for neural operator training and the Jupyter file `./pde_safe_control/train_cbf_hyper_new.ipynb` for neual BCBF training. Similarly, see `./pde_safe_control/train_para_all_pf.jl` to train neural operator and the Jupyter file `./pde_safe_control/train_cbf_parabolic.ipynb` for neual BCBF training under parabolic equation. see `./pde_safe_control/train_ns_all_pf.jl` to train neural operator and the Jupyter file `./pde_safe_control/train_cbf_ns.ipynb` for neual BCBF training under Navier-Stokes equation. 


## Evaluation of online safety filtering
For the safety filtering over the collected trajectories, see Jupyter file `./pde_safe_control/train_cbf.ipynb` for hyperbolic equation, `./pde_safe_control/test_cbf_parabolic.ipynb` for parabolic equation, and `./pde_safe_control/train_cbf_ns.ipynb` for Navier-Stokes equation. For the reward and PF metric metric evaluation, see Jupyter file `./PDEControlGym/examples/transportPDE/HyperbolicPDEExample.ipynb` for hyperbolic equation,  Jupyter file `./PDEControlGym/examples/reactionDiffusionPDE/ParabolicPDEExample.ipynb` for parabolic equation and Jupyter file `./PDEControlGym/examples/NavierStokes/NS2Dtest.ipynb` Navier-Stokes equation.



