import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd
import numpy as np

# Data from the table
# \phi t Y
# data = {
#     "Threshold": ["0", "0.5", "2", "5", "10"],
#     "Reward mean": [157.90, 158.60, 165.04, 127.18, 28.61],
#     "Reward std": [37.46, 37.76, 43.73, 82.67, 64.03],
#     "PF Rate": [0.63,0.68,0.71,0.73,0.57]
# }

# \phi Y
data = {
    "Threshold": ["0", "0.5", "2", "5", "10"],
    "Reward mean": [157.90, 158.45, 162.26, 114.40, 27.28],
    "Reward std": [37.46, 37.82, 44.53, 83.25, 57.62],
    "PF Rate": [0.63,0.65,0.63,0.67,0.57]
}

df = pd.DataFrame(data)

# Defining the thresholds and bar width
thresholds = np.arange(len(df['Threshold']))
bar_width = 0.35

# Using the 'Paired' palette
palette_paired = sns.color_palette("Paired", n_colors=4)
df['Reward mean'] = df['Reward mean'] + 100
# # Adjusting the blue bars (reward) to start from the x-axis by filling the gap between -100 and 0
fig, ax1 = plt.subplots(figsize=(10, 8))

# Bar plot for reward (left y-axis) with an offset on the left
ax1.bar(thresholds - bar_width / 2, df['Reward mean'], yerr=df['Reward std'],
        width=bar_width, color=palette_paired[1], label='Reward', capsize=5, bottom=-100)
ax1.set_xlabel('Filtering Threshold $\eta$', fontsize=24)
ax1.set_ylabel('Reward', color=palette_paired[1], fontsize=24)
ax1.tick_params(axis='y', labelcolor=palette_paired[1], labelsize=24)
ax1.tick_params(axis='x', labelsize=24)
ax1.set_title('Reward and PF Rate with filtering $\phi(Y)$', fontsize=24)
ax1.set_xticks(thresholds)
ax1.set_xticklabels(df['Threshold'], fontsize=24)
ax1.set_ylim(-100, max(df['Reward mean']) + 50)  # Set y-axis range for reward

# Creating a second y-axis for the PF steps (right y-axis)
ax2 = ax1.twinx()
ax2.bar(thresholds + bar_width / 2, df['PF Rate'],
        width=bar_width, color=palette_paired[3], label='PF Rate', alpha=0.7)
ax2.set_ylabel('PF Rate', color=palette_paired[3], fontsize=24)
ax2.tick_params(axis='y', labelcolor=palette_paired[3], labelsize=24)
ax2.set_ylim(0, 0.8) 

# Adding a legend
fig.legend(loc='upper right', bbox_to_anchor=(0.88, 0.94), fontsize=24)

plt.tight_layout()
pdf_path = "phi_Y_threshold.pdf"
fig.savefig(pdf_path)
plt.show()
