import bnn

method_dict = {
    'fac'   : (bnn.FactorisedLinear,   bnn.FactorisedConv2d,    None),
    'facLR' : (bnn.FactorisedLRLinear, bnn.FactorisedLRConv2d,  None),
    'rand'  : (bnn.RandomLinear,       bnn.RandomConv2d,        None),
    'gi'    : (bnn.GILinear,           bnn.GIConv2d,            None),
    'li'    : (bnn.LILinear,           bnn.LIConv2d,            None),
    'det'   : (bnn.DetLinear,          bnn.DetConv2d,           None),
    'gigp'  : (bnn.KernelGIGP,         None,                    bnn.KernelGIGP),
    'ligp'  : (bnn.KernelLIGP,         None,                    bnn.KernelLIGP),
}


class APSpec:
    def __init__(self, lower, top):
        self.lower = lower
        self.top = top
        self.lower_linear, self.lower_conv2d = method_dict[lower][:2]
        self.top_linear,   self.top_conv2d, self.out = method_dict[top]
