# Code to prevent MAGMA warnings from printing
import sys
import re

regexs = [
    "   WARNING batched routines are designed for small sizes. It might be better to use the",
    "   Native/Hybrid classical routines if you want good performance.",
    "========================================================================================="
]
regexs = [re.compile(regex) for regex in regexs]

for line in sys.stdin:
    match = any(regex.match(line) for regex in regexs)

    if not match:
        print(line, end = '')
