Introduction
============

All the necessary code to reproduce our experiments is contained in these files. We recommend Python >= 3.6 (3.7 preferable) and torch >= 1.4.0.

Running experiments
===================

To facilitate the running of experiments, we use `make`. For instance, to run our CIFAR-10 experiments, execute `make cifar10` in the command line. The other options are as follows:

* `uci`: runs the UCI experiments for BNNs. Note we recommend making use of multithreading using the option `-j num_threads`
* `linear`: runs the deep linear experiments
* `toy`: runs the toy experiments. As HMC is not supported in our overall framework (as we focus on variational inference), the code for the HMC toy experiment can be found in the folder "toy_hmc".
* `ucigp`: runs the UCI experiments on deep GPs (Appendix J)
* `mnist_500`: runs the MNIST 500 experiments (Appendix K)

For UCI, the datasets we used can be obtained at https://github.com/yaringal/DropoutUncertaintyExps/tree/master/UCI_Datasets


Code structure
==============

Our code attempts to provide a coherent library for the variational inference methods for BNNs mentioned in the paper. 
As such, for each method we mirror the PyTorch `nn` API by defining Bayesian variants of standard modules, such as `Linear` and `Conv2d`.
The main elements of the library can be found in the "bnn" folder.
The key Python files for the variational methods we consider are:

* `inducing.py`: contains code for both local inducing (`li`) and global inducing (`gi`)
* `factorised.py`: contains code for factorised (`fac`)
* `factorised_local_reparam.py`: contains code for factorised using the local reparameterization trick (`facLR`). Note this is not compatible with the inducing point methods as it does not properly propagate covariances.
* `gp.py`: contains code for deep GP methods, local inducing (`ligp`) and global inducing (`gigp`)
* `random.py`: contains code for a random layer with weights sampled from NealPrior

The variational posterior is chosen using "ap_spec.py", which allows the user to select a variational posterior for the top layer (`ap_top`) and one for the lower layers (`ap_lower`).
Other important files are "abstract_bnn.py" and "general.py". 
The first of these defines the framework for the variational layers to fit in for BNNs, while the second defines a wrapper for the network that returns both the output and the KL term.
Our priors for the BNNs can be found in "bnn/priors.py"
We additionally provide example models in the "models" folder, which includes the models used for the experiments:

* `fc_uci.py`: the fully-connected network used for the UCI experiments
* `lenet.py`: the LeNet-inspired network used for MNIST 500
* `resnet8.py`: the ResNet-inspired network used for CIFAR-10
* `uci_resgp.py`: the modified deep GP with ResNet-inspired skip connections from Salimbeni & Deisenroth 2017

Finally, we include several scripts, which we used for our experiments. These show how our library can be used for actual experiments. They are: `linear.py`, `conv.py`, `uci.py`, and `ucigp.py`.
