"""
Materialize all the AI-generated reviews that are not detected by Binoculars
"""
import sqlite3
from pathlib import Path

import binoculars.detector
import pandas

from config import DB_PATH

THRESHOLD = binoculars.detector.BINOCULARS_FPR_THRESHOLD
GENAI_ANOMALOUS = Path(__file__).parent / "genai_undetected"
GENAI_ANOMALOUS.mkdir(exist_ok=True)

query = f"""
select * from genai_review
where type='neutral' and binocular_score > {THRESHOLD}
"""
conn = sqlite3.connect(str(DB_PATH))
all_paper_reviews = pandas.read_sql_query(query, conn)
for _, review in all_paper_reviews.iterrows():
    textual_review = review["generated"]
    with open(str(GENAI_ANOMALOUS / f"{review['paper_id']}.txt"), "w") as h:
        h.write(textual_review)
