"""
Plot the bias induced by the prompts on the decision
"""
import sqlite3
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

from config import DB_PATH
from dataset_metrics.extract_info_from_reviews import biases, color_biases, RELAXED_TICKS_SCORES, \
    EXTENDED_SCORES

plt.rcParams.update({'font.size': 18})


def get_bias_histograms():
    histograms = {
        "positive": {s: 0 for s in EXTENDED_SCORES},
        "negative": {s: 0 for s in EXTENDED_SCORES},
        "neutral": {s: 0 for s in EXTENDED_SCORES},
    }

    with sqlite3.connect(str(DB_PATH)) as connection:
        all_genai_reviews = pd.read_sql_query("select * from genai_review", connection)
        for _, genai_review in all_genai_reviews.iterrows():
            bias = genai_review['type']
            rating = genai_review['rating']
            histograms[bias][rating] += 1
    return histograms


if __name__ == '__main__':
    x = np.arange(len(EXTENDED_SCORES))
    width = 0.2
    n_biases = len(biases)
    histograms = get_bias_histograms()
    fig1, ax1 = plt.subplots()
    for i, b in enumerate(biases):
        ax1.bar(x + i * width, [histograms[b][k] for k in EXTENDED_SCORES], width=width, label=b,
                color=color_biases[i])
    ax1.set_xticks(x + width * (n_biases - 1) / 2, RELAXED_TICKS_SCORES)
    ax1.set_xlabel("Score")
    ax1.set_ylabel("# of GenAI reviews")
    ax1.set_yscale('log')
    ax1.legend()
    fig1.tight_layout()

    # fig2, ax2 = plt.subplots()
    # handles, labels = ax1.get_legend_handles_labels()
    # ax2.legend(handles, labels, loc='center', ncol=len(biases))
    # ax2.axis('off')
    # fig2.tight_layout()

    plt.show()
