import sqlite3

import pandas
from pandas import DataFrame

from config import DB_PATH


def _create_2018_2019_2020_2021(data: DataFrame):
    return f"""**Main Review.** {data["main_review"]}
    **Confidence.** {data["confidence"]}
    **Rating.** {data["rating"]}
    """


def _create_2022(data: DataFrame):
    return f"""**Summary of the Paper.** {data["summary"]}
    **Main Review.** {data["main_review"]}
    **Summary of the Review.** {data["summary_of_the_review"]}
    **Correctness.** {data["correctness"]}
    **Technical Novelty and Significance.** {data["technical_novelty_and_significance"]}
    **Empirical Novelty and Significance.** {data["empirical_novelty_and_significance"]}
    **Flags for Ethics Review.** {data["flag_for_ethics_review"]}
    **Confidence.** {data["confidence"]}
    **Rating.** {data["rating"]}
    """


def _create_2023(data: DataFrame):
    return f"""**Summary of the Paper.** {data["summary"]}
    **Summary of the Review.** {data["summary_of_the_review"]}
    **Correctness.** {data["correctness"]}
    **Technical Novelty and Significance.** {data["technical_novelty_and_significance"]}
    **Empirical Novelty and Significance.** {data["empirical_novelty_and_significance"]}
    **Flags for Ethics Review.** {data["flag_for_ethics_review"]}
    **Confidence.** {data["confidence"]}
    **Rating.** {data["rating"]}
    """


def _create_2024_2025(data: DataFrame):
    return f"""**Summary of the Paper.** {data["summary"]}
    **Flags for Ethics Review.** {data["flag_for_ethics_review"]}
    **Soundness.** {data["soundness"]}
    **Presentation.** {data["presentation"]}
    **Contribution.** {data["contribution"]}
    **Strengths.** {data["strength"]}
    **Weaknesses.** {data["weaknesses"]}
    **Questions.** {data["questions"]}
    **Confidence.** {data["confidence"]}
    **Rating.** {data["rating"]}
    """


review_template = {
    2018: _create_2018_2019_2020_2021,
    2019: _create_2018_2019_2020_2021,
    2020: _create_2018_2019_2020_2021,
    2021: _create_2018_2019_2020_2021,
    2022: _create_2022,
    2023: _create_2023,
    2024: _create_2024_2025,
    2025: _create_2024_2025

}


def create_textual_review(data: DataFrame, year: int):
    return review_template[year](data)


def extract_review_using_id(reviewer_id:str):
    with sqlite3.connect(str(DB_PATH)) as c:
        result = pandas.read_sql_query("""
            select * from review join submission on review.paper_id = submission.id
            where reviewer_id = ? 
        """, c, params=[reviewer_id])
    year = result['when_submitted'].item()
    print(create_textual_review(next(result.iterrows())[1], year))


extract_review_using_id("H1NEs7Clz")