#pragma once

#include <torch/extension.h>

torch::Tensor
spinner_async_cpu(torch::Tensor rowptr, torch::Tensor col,
            int num_parts, float capacity, float beta, int max_iter,
            float halting_eps, int halting_window,
            bool log, int num_threads);

torch::Tensor
spinner_gas_cpu(torch::Tensor rowptr, torch::Tensor col,
            int num_parts, float capacity, float beta, int max_iter,
            float halting_eps, int halting_window,
            bool log, int num_threads);


torch::Tensor
spinner_cpu(torch::Tensor rowptr, torch::Tensor col,
            int num_parts, float capacity, float beta, int max_iter,
            float halting_eps, int halting_window,
            bool log, int num_threads);

torch::Tensor
grinnder_async_cpu(torch::Tensor rowptr, torch::Tensor col,
            int num_parts, float capacity, float beta, int max_iter,
            float halting_eps, int halting_window, bool reuse_aware, bool refine,
            bool log, int num_threads,
            torch::optional<torch::Tensor> orig_labels);

torch::Tensor
grinnder_fast_async_cpu(torch::Tensor rowptr, torch::Tensor col,
            int num_parts, float capacity, float beta, int max_iter, int progressive_window,
            float halting_eps, int halting_window, bool reuse_aware, bool refine,
            bool log, int num_threads,
            torch::optional<torch::Tensor> orig_labels);

torch::Tensor
random_cpu(torch::Tensor rowptr, torch::Tensor col,
            int num_parts, bool log);