""" Torch compiler related helpers """
import os
import os.path as osp

from torch.utils import cpp_extension

def load_grinnder_ext():
    if not os.path.exists('build/'):
        os.makedirs('build/')
    sources = [
        osp.join('csrc/grinnder.cpp'),
        osp.join('csrc/cpu/relabel_cpu.cpp'),
        osp.join('csrc/cuda/async_cuda.cu'),
        osp.join('csrc/cpu/partitioning.cpp'),
        osp.join('csrc/cpu/masking.cpp'),
    ]
    return cpp_extension.load(
        name='grinnder',
        sources=sources,
        extra_cflags=['-fopenmp', '-O3'],
        extra_cuda_cflags=['--expt-relaxed-constexpr'],
        with_cuda=True,
        verbose=False,
        build_directory='build/'
    )
