import matplotlib.pyplot as plt
import gymnasium as gym
import pandas as pd
import random


def extract_grid(env_id=None, seed=None, plot=False):
    env = gym.make(env_id, render_mode="rgb_array")
    obs, info = env.reset(seed=seed)

    base_env = env.unwrapped

    grid_data = []
    for x in range(base_env.width):
        for y in range(base_env.height):
            cell = base_env.grid.get(x, y)
            if cell is not None:
                grid_data.append(
                    {
                        "pos": (x, y),
                        "type": cell.type,
                        "color": getattr(cell, "color", None),
                    }
                )
            else:
                grid_data.append({"pos": (x, y), "type": "empty", "color": None})

    agent_info = {"pos": tuple(base_env.agent_pos), "dir": base_env.agent_dir}

    mission = base_env.mission
    if plot==True:
        img = env.render()
        plt.imshow(img)
        plt.axis("off")
        plt.title(f"Mission: {obs['mission']}")
        plt.show()
        env.close()
    return {"agent": agent_info, "mission": mission, "grid": grid_data}


if __name__ == "__main__":
    """
        DoorKey:
        MiniGrid-DoorKey-5x5-v0, MiniGrid-DoorKey-6x6-v0, MiniGrid-DoorKey-8x8-v0, MiniGrid-DoorKey-16x16-v0
    """
    grid = pd.DataFrame()
    mission = []
    grid_env = []
    agent_pos = []
    N = 5
    for i in range(1):
        env_snapshot = extract_grid(
            env_id=f"MiniGrid-DoorKey-{N}x{N}-v0", seed=random.randint(0, 1000), plot=False
        )
        mission.append(env_snapshot["mission"])
        grid_env.append(env_snapshot["grid"])
        agent_pos.append(env_snapshot["agent"])
    grid["mission"] = mission
    grid["agent"] = agent_pos
    grid["fsm"] = grid_env
    grid.to_csv(f"MiniGrid-DoorKey-{N}-v0.csv", index=False)
