import numpy as np


def gradient_F1(x, y):
    """
    Compute the gradient of F1 at (x, y).

    Args:
    - x (float): x-coordinate.
    - y (float): y-coordinate.

    Returns:
    - np.array: gradient as [df/dx, df/dy].
    """
    df_dx = 2 * (x - 7)
    df_dy = 4 * (y - 18)
    return np.array([df_dx, df_dy])


def gradient_F2(x, y):
    """
    Compute the gradient of F2 at (x, y).

    Args:
    - x (float): x-coordinate.
    - y (float): y-coordinate.

    Returns:
    - np.array: gradient as [df/dx, df/dy].
    """
    df_dx = 4 * (x - 18)
    df_dy = 2 * (y - 13)
    return np.array([df_dx, df_dy])


eta = 0.05
alpha = 1
K = 3
R = 8
# local SGD
w_1_list = [np.zeros(2)] * (K * R + 1)
w_2_list = [np.zeros(2)] * (K * R + 1)

for r in range(R):
    for k in range(K):
        w_1_list[r * K + k + 1] = w_1_list[r * K + k] - eta * gradient_F1(
            w_1_list[r * K + k][0], w_1_list[r * K + k][1]
        )
        w_2_list[r * K + k + 1] = w_2_list[r * K + k] - eta * gradient_F2(
            w_2_list[r * K + k][0], w_2_list[r * K + k][1]
        )
    temp = 0.5 * w_1_list[(r + 1) * K] + 0.5 * w_2_list[(r + 1) * K]
    w_1_list[(r + 1) * K] = temp
    w_2_list[(r + 1) * K] = temp

print("Local SGD 1")
for item in w_1_list:
    print(item[0], item[1])
print("Local SGD 2")
for item in w_2_list:
    print(item[0], item[1])


# personalized local SGD

w_1_list = [np.zeros(2)] * (K * R + 1)
w_2_list = [np.zeros(2)] * (K * R + 1)
theta_1_list = [np.zeros(2)] * (K * R + 1)
theta_2_list = [np.zeros(2)] * (K * R + 1)
for r in range(R):
    for k in range(K):
        w_1_list[r * K + k + 1] = w_1_list[r * K + k] - eta * gradient_F1(
            w_1_list[r * K + k][0] + theta_1_list[r * K + k][0],
            w_1_list[r * K + k][1] + theta_1_list[r * K + k][1],
        )
        theta_1_list[r * K + k + 1] = theta_1_list[
            r * K + k
        ] - alpha * eta * gradient_F1(
            w_1_list[r * K + k][0] + theta_1_list[r * K + k][0],
            w_1_list[r * K + k][1] + theta_1_list[r * K + k][1],
        )
        w_2_list[r * K + k + 1] = w_2_list[r * K + k] - eta * gradient_F2(
            w_2_list[r * K + k][0] + theta_2_list[r * K + k][0],
            w_2_list[r * K + k][1] + theta_2_list[r * K + k][1],
        )
        theta_2_list[r * K + k + 1] = theta_2_list[
            r * K + k
        ] - alpha * eta * gradient_F2(
            w_2_list[r * K + k][0] + theta_2_list[r * K + k][0],
            w_2_list[r * K + k][1] + theta_2_list[r * K + k][1],
        )
    temp = 0.5 * w_1_list[(r + 1) * K] + 0.5 * w_2_list[(r + 1) * K]
    w_1_list[(r + 1) * K] = temp
    w_2_list[(r + 1) * K] = temp

print("Personalized Local SGD 1")
for item1, item2 in zip(w_1_list, theta_1_list):
    print(item1[0] + item2[0], item1[1] + item2[1])
print("Personalized Local SGD 2")
for item1, item2 in zip(w_2_list, theta_2_list):
    print(item1[0] + item2[0], item1[1] + item2[1])

# print(w_1_list)
# print(w_2_list)
# Test
# x, y = 7, 13
# print(f"Gradient of F1 at ({x}, {y}):", gradient_F1(x, y))
# print(f"Gradient of F2 at ({x}, {y}):", gradient_F2(x, y))
