#!/bin/bash

methods=("main")

datasets=("cifar10" "cifar100" "stl")
distrs=(0 1)
nc=1

lr=0.05
k=500
t=0.1

gpu=3
seed=999

time=$(date +"%Y-%m-%d %H:%M:%S")

for method in "${methods[@]}"; do
    for dataset in "${datasets[@]}"; do
        for distr in "${distrs[@]}"; do
            file_path="./results/${method}_${dataset}_${distr}_${nc}_${k}_${t}_${seed}.log"
            nohup python -u ${method}.py -dataset ${dataset} -distr ${distr} -nc ${nc} -k ${k} -t ${t} -gpu ${gpu} -lr ${lr} -seed ${seed} > ${file_path} 2>&1 &
        done
        if [ $gpu -eq 7 ]; then
            ((gpu=0))
        else
            ((gpu++))
        fi
    done
done