from core.run import run
from core.task_schedule import wait_schedule, Task, available_devices
from multiprocessing import Process
import datetime
import argparse
import numpy as np


if __name__ == "__main__":
    now = datetime.datetime.now().strftime("%Y-%m-%d-%H-%M-%S")
    tasks = []
    for seed in np.random.randint(0, 10000, 5):
        for K in [1]:
            args = argparse.Namespace(
                T=5000, K=K, seed=seed, ho_algo='ablo', dataset='corrupted_mnist', width=28, x_dim=784,
                loss='ReweightingMLP', theta_mlp_shape=[784, 256, 10],
                m_tr=2000, m_val=1000, m_te=1000, m_mval=200, batch_size=32, lr_h=10, lr_l=0.01, wd_h=0., wd_l=0.,
                mm_h=0.)
            args.workspace_root = "workspace/runs/rw_mnist/ablo_K_{}/seed_{}_K_{}".format(
                now, seed, K)
            p = Process(target=run, args=(args,))
            tasks.append(Task(p, 1))
    wait_schedule(tasks, devices=available_devices() * 5)

