from peft import LoftQConfig, LoraConfig

from mow.scripts.train.train_expert import TrainExpertConfig

loftq_config = LoftQConfig(loftq_bits=4)

config = TrainExpertConfig(
    main_model="meta-llama/Llama-3.2-1B-Instruct",
    lora_config=LoraConfig(
        r=8,
        lora_alpha=16,
        target_modules=["q_proj", "k_proj"],
        lora_dropout=0.1,
        bias="none",
        task_type="CAUSAL_LM",
        init_lora_weights="loftq",
        loftq_config=loftq_config,
    ),
    train_dataset="datasets/virtualhome/0/train.jsonl",
    eval_dataset="datasets/virtualhome/0/test.jsonl",
)
