import argparse

from mow.utils.program import Program


class TestArgs(argparse.Namespace):
    type: str
    config: str


class TestProgram(Program, args=TestArgs, name="test", help="Test a model."):
    @staticmethod
    def add_arguments(parser: argparse.ArgumentParser):
        parser.add_argument(
            "type", choices=["expert", "mow"], help="Type of model to train"
        )
        parser.add_argument("config", help="Path to the model config file")

    @staticmethod
    def main(args: TestArgs):
        match args.type:
            case "expert":
                from mow.scripts.test_expert import (
                    TrainExpertConfig,
                    test_expert,
                )

                test_expert(TrainExpertConfig.from_file(args.config))
            case "mow":
                from mow.scripts.test_mow import TrainMoWConfig, test_mow

                test_mow(TrainMoWConfig.from_file(args.config))
            case _:
                raise ValueError(f"Unknown model type: {args.type}")
