from transformers import GenerationMixin, PreTrainedTokenizerBase


def init_model_or_tokenizer(
    *,
    model: GenerationMixin | None = None,
    tokenizer: PreTrainedTokenizerBase | None = None,
):
    if tokenizer is not None:
        tokenizer.pad_token = "<|end_of_text|>"
    if model is not None:
        if tokenizer is None:
            raise ValueError("Tokenizer must be provided if model is provided.")
        model.generation_config.pad_token_id = tokenizer.pad_token_id
